% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVPVAR.R
\name{TVPVAR}
\alias{TVPVAR}
\title{Time-varying parameter vector autoregression}
\usage{
TVPVAR(x, configuration = list(l = c(0.99, 0.99), nlag = 1, prior = NULL))
}
\arguments{
\item{x}{zoo data matrix}

\item{configuration}{model configuration}

\item{nlag}{Lag length}

\item{prior}{List of prior VAR coefficients and variance-covariance matrix}

\item{l}{forgetting factors (kappa1, kappa2)}
}
\value{
Estimate TVP-VAR model
}
\description{
Estimate TVP-VAR model
}
\examples{
\donttest{
data("dy2012")
prior = BayesPrior(dy2012, nlag=1)
fit = TVPVAR(dy2012, configuration=list(nlag=1, prior=prior, l=c(0.99,0.99)))
}
}
\references{
Koop, G., & Korobilis, D. (2014). A new index of financial conditions. European Economic Review, 71, 101-116.

Antonakakis, N., Chatziantoniou, I., & Gabauer, D. (2020). Refined measures of dynamic connectedness based on time-varying parameter vector autoregressions. Journal of Risk and Financial Management, 13(4), 84.
}
\author{
David Gabauer
}
