% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_ellipsoid.R
\name{confidence_ellipsoid}
\alias{confidence_ellipsoid}
\title{Confidence Ellipsoid Coordinates}
\usage{
confidence_ellipsoid(
  .data,
  x,
  y,
  z,
  .group_by = NULL,
  conf_level = 0.95,
  robust = FALSE
)
}
\arguments{
\item{.data}{data frame or tibble.}

\item{x}{column name for the x-axis variable.}

\item{y}{column name for the y-axis variable.}

\item{z}{column name for the z-axis variable.}

\item{.group_by}{column name for the grouping variable (\code{NULL} by default). Note that this grouping variable must be a factor.}

\item{conf_level}{confidence level for the ellipsoid (0.95 by default).}

\item{robust}{optional (\code{FALSE} by default). When set to \code{TRUE}, it indicates that robust estimation method is employed to calculate the coordinates of the ellipsoid. The location is the 1-step M-estimator with the biweight psi function. The scale is the Minimum Covariance Determinant (MCD) estimator. Raymaekers and Rousseeuw (2019).}
}
\value{
Data frame of the coordinate points.
}
\description{
Compute the coordinate points of confidence ellipsoids at a specified confidence level.
}
\examples{
# Data
data("glass", package = "ConfidenceEllipse")
# Confidence ellipsoid
ellipsoid <- confidence_ellipsoid(.data = glass, x = SiO2, y = Na2O, z = Fe2O3)
ellipsoid_grp <- confidence_ellipsoid(
.data = glass,
x = SiO2,
y = Na2O,
z = Fe2O3,
.group_by = glassType
)

}
\author{
Christian L. Goueguel
}
