% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV.R
\name{cv.compCL}
\alias{cv.compCL}
\title{Cross-validation for compCL.}
\usage{
cv.compCL(y, Z, Zc = NULL, intercept = FALSE, lam = NULL,
          nfolds = 10, foldid, trim = 0, keep = FALSE, ...)
}
\arguments{
\item{y}{response vector with length n.}

\item{Z}{\code{z} matrix as in \code{compCL}.}

\item{Zc}{\code{Zc} matrix as in \code{compCL}. Default is \code{NULL}.}

\item{intercept}{whether to include an intercept.
Default is \code{FALSE}.}

\item{lam}{a user supplied lambda sequence.
If \code{lam} is provided as a scaler and \code{nlam}\eqn{>1}, \code{lam} sequence is created starting from
\code{lam}. To run a single value of \code{lam}, set \code{nlam}\eqn{=1}.
The program will sort user-defined \code{lambda} sequence in decreasing order.}

\item{nfolds}{number of folds, default is 10. The smallest allowable value is \code{nfolds=3}.}

\item{foldid}{an optional vector of values between 1 and the sample size \code{n}, providing the fold
assignments. If supplied, \code{nfold} can be missing.}

\item{trim}{percentage to be trimmed off the prediction errors from either side; default is 0.}

\item{keep}{If \code{keep=TRUE}, fitted models in cross validation are reported.
Default is \code{keep=FALSE}.}

\item{...}{other arguments that can be passed to \code{compCL}.}
}
\value{
an object of S3 class \code{"cv.compCL"} is returned, which is a list constaining:
\item{compCL.fit}{a fitted \code{\link{compCL}} object for the full data.}
\item{lam}{the sequence of \code{lam}.}
\item{Ftrim}{a list of cross-validation results without trimming:
               \itemize{
               \item \code{cvm} the mean cross-validated error -  a vector of
                     length \code{length(lam).}
               \item \code{cvsd} standard error of cvm.
               \item \code{cvupper} upper curve = \code{cvm+cvsd}.
               \item \code{cvlo} lower curve = \code{cvm-cvsd}.
               \item \code{lam.min} the optimal value of \code{lam} that gives minimum cross
                           validation error.
               \item \code{lam.1se} the largest value of lam such that the error is within 1
                     standard error of the minimum \code{cvm}.
               }
            }
\item{Ttrim}{a list of cross-validation result with \code{trim*100\%},
             The structure is the same as that for \code{Ftrim}.}
\item{foldid}{the values of \code{foldid}.}
}
\description{
k-fold cross-validation for compCL; produce a plot and return
optimal values of \code{lam}.
}
\details{
cross-validation and fit full data with selected model.
}
\examples{
p = 30
n = 50
beta = c(1, -0.8, 0.6, 0, 0, -1.5, -0.5, 1.2)
beta = c(beta, rep(0, times = p - length(beta)))
Comp_data = comp_Model(n = n, p = p, beta = beta, intercept = FALSE)
cvm1 <- cv.compCL(y = Comp_data$y, Z = Comp_data$X.comp,
                  Zc = Comp_data$Zc, intercept = Comp_data$intercept)

plot(cvm1)
coef(cvm1)
## selection by "lam.min" criterion
which(abs(coef(cvm1, s = "lam.min")[1:p]) > 0)
## selection by "lam.1se" criterion
which(abs(coef(cvm1, s= "lam.1se")[1:p]) > 0)

Comp_data2 = comp_Model(n = 30, p = p, beta = Comp_data$beta, intercept = FALSE)
y_hat = predict(cvm1, Znew = Comp_data2$X.comp, Zcnew = Comp_data2$Zc)
plot(Comp_data2$y, y_hat,
     xlab = "Observed response", ylab = "Predicted response")

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979
}
\seealso{
\code{\link{compCL}} and \code{\link{cv.compCL}},
and \code{\link[=coef.cv.compCL]{coef}},
\code{\link[=predict.cv.compCL]{predict}} and
\code{\link[=plot.cv.compCL]{plot}} methods for \code{"cv.compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
