% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{coef.FuncompCGL}
\alias{coef.FuncompCGL}
\title{Extract estimated coefficients from a \code{"FuncompCGL"} object.}
\usage{
\method{coef}{FuncompCGL}(object, s = NULL, ...)
}
\arguments{
\item{object}{fitted \code{\link{FuncompCGL}} object.}

\item{s}{value(s) of the penalty parameter \code{lam} at which coefficients
are requested. Default (\code{NULL}) is the entire sequence used to
create the model.}

\item{\dots}{Not used.}
}
\value{
The coefficients at the requested tuning parameter values in \code{s}.
}
\description{
get the coefficients at the requested values for \code{lam}
from a fitted \code{\link{FuncompCGL}} object.
}
\details{
\code{s} is a vector of lambda values at which the coefficients are requested. If \code{s} is not in the
\code{lam} sequence used for fitting the model, the \code{coef} function will use linear
interpolation, so the function should be used with caution.
}
\examples{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
Data <- Fcomp_Model(n = 50, p = p, m = 2, intercept = TRUE,
                    SNR = 2, sigma = 2, rho_X = 0, rho_T = 0.5, df_beta = df_beta,
                    n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))

m1 <- FuncompCGL(y = Data$data$y, X = Data$data$Comp , Zc = Data$data$Zc,
                 intercept = Data$data$intercept, k = df_beta)
coef(m1)
coef(m1, s = c(0.5, 0.1, 0.01))

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{FuncompCGL}}, and \code{\link[=predict.FuncompCGL]{predict}},
\code{\link[=plot.FuncompCGL]{plot}} and \code{\link[=print.FuncompCGL]{print}}
methods for \code{"FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
