% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraintsReg.R
\name{classo}
\alias{classo}
\title{Fit a linearly constrained linear regression model with lasso regularization.}
\usage{
classo(y, Z, Zc = NULL, intercept = TRUE, pf = rep(1, times = p),
       lam = NULL, nlam = 100,lambda.factor = ifelse(n < p, 0.05, 0.001),
       dfmax = p, pfmax = min(dfmax * 1.5, p),
       u = 1, mu_ratio = 1.01, tol = 1e-10,
       outer_maxiter = 3e+08, outer_eps = 1e-8,
       inner_maxiter = 1e+6, inner_eps = 1e-8,
       A = rep(1, times = p), b = 0, beta.ini)
}
\arguments{
\item{y}{a response vector with length n.}

\item{Z}{a design matrix, with dimension \eqn{n \times p}{n*p}.}

\item{Zc}{design matrix for unpenalized variables. Default value is NULL.}

\item{intercept}{Boolean, specifying whether to include an intercept.
Default is TRUE.}

\item{pf}{penalty factor, a vector of length p. Zero implies no shrinkage. Default value for each entry is 1.}

\item{lam}{a user supplied lambda sequence.
If \code{lam} is provided as a scaler and \code{nlam}\eqn{>1}, \code{lam} sequence is created starting from
\code{lam}. To run a single value of \code{lam}, set \code{nlam}\eqn{=1}.
The program will sort user-defined \code{lambda} sequence in decreasing order.}

\item{nlam}{the length of the \code{lam} sequence. Default is 100. No effect if \code{lam} is
provided.}

\item{lambda.factor}{the factor for getting the minimal lambda in the \code{lam} sequence,
where \code{min(lam)} = \code{lambda.factor} * \code{max(lam)}.
\code{max(lam)} is the smallest value of \code{lam} for which all penalized coefficients become zero.
If \eqn{n >= p}, the default is \code{0.001}. If \eqn{n < p}, the default is \code{0.05}.}

\item{dfmax}{limit the maximum number of groups in the model. Useful for handling very large \eqn{p}, if a partial path is desired.
Default is \eqn{p}.}

\item{pfmax}{limit the maximum number of groups ever to be nonzero. For example once a group enters the model along the path,
no matter how many times it re-enters the model through the path, it will be counted only once.
Default is \code{min(dfmax*1.5, p)}.}

\item{u}{the inital value of the penalty parameter of the augmented Lagrange method adopted in the outer loop. Default value is 1.}

\item{mu_ratio}{the increasing ratio, with value at least 1, for \code{u}. Default value is 1.01.
Inital values for scaled Lagrange multipliers are set as 0.
If \code{mu_ratio} < 1, the program automatically set \code{u} as 0 and \code{outer_maxiter} as 1, indicating
that there is no linear constraint.}

\item{tol}{tolerance for the estimated coefficients to be considered as non-zero, i.e., if \eqn{abs(\beta_j)} < \code{tol}, set \eqn{\beta_j} as 0.
Default value is 1e-10.}

\item{outer_maxiter, outer_eps}{\code{outer_maxiter} is the maximum number of loops allowed for the augmented Lanrange method;
and \code{outer_eps} is the corresponding convergence tolerance.}

\item{inner_maxiter, inner_eps}{\code{inner_maxiter} is the maximum number of loops allowed for the coordinate descent;
and \code{inner_eps} is the corresponding convergence tolerance.}

\item{A, b}{linear equalities of the form \eqn{A\beta_p = b}, where \eqn{b} is a scaler,
and \eqn{A} is a row-vector of length \code{p}. Default values: \eqn{b} is 0 and \code{A = matrix(1, ncol = p)}.}

\item{beta.ini}{inital value of the coefficients. Can be unspecified.}
}
\value{
A list of
\item{beta}{a matrix of coefficients.}
\item{lam}{the sequence of lambda values.}
\item{df}{a vector, the number of nonzero coefficients for \code{Z} at each value of lambda.}
\item{npass}{total number of iteration.}
\item{error}{a vector of error flag.}
}
\description{
Fit a linearly constrained linear model with lasso regularization.
}
