/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection.notifymap;

import java.util.ArrayList;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.ConstVectorMap;
import net.infonode.util.collection.map.MapAdapter;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;
import net.infonode.util.collection.notifymap.AbstractConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ConstChangeNotifyMap;
import net.infonode.util.signal.Signal;
import net.infonode.util.signal.SignalListener;

public class ConstChangeNotifyVectorMap
extends AbstractConstChangeNotifyMap {
    private ConstVectorMap vectorMap = new ConstVectorMap();
    private ArrayList mapListeners;

    protected void firstListenerAdded() {
        this.mapListeners = new ArrayList(this.vectorMap.getMapCount() + 2);
        for (int i = 0; i < this.vectorMap.getMapCount(); ++i) {
            this.addMapListener(i);
        }
    }

    protected void lastListenerRemoved() {
        for (int i = this.vectorMap.getMapCount() - 1; i >= 0; --i) {
            this.removeMapListener(i);
        }
        this.mapListeners = null;
    }

    private Object getValue(Object object, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            Object object2 = this.getMap(i).get(object);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public int getMapIndex(ConstMap constMap) {
        return this.vectorMap.getMapIndex(constMap);
    }

    public void addMap(ConstChangeNotifyMap constChangeNotifyMap) {
        this.addMap(this.vectorMap.getMapCount(), constChangeNotifyMap);
    }

    public void addMap(int n, ConstChangeNotifyMap constChangeNotifyMap) {
        this.vectorMap.addMap(n, constChangeNotifyMap);
        if (this.getChangeSignalInternal().hasListeners()) {
            this.addMapListener(n);
            MapAdapter mapAdapter = new MapAdapter();
            ConstMapIterator constMapIterator = constChangeNotifyMap.constIterator();
            while (constMapIterator.atEntry()) {
                Object object = this.getValue(constMapIterator.getKey(), 0, n);
                if (object == null) {
                    Object object2 = constMapIterator.getValue();
                    mapAdapter.put(constMapIterator.getKey(), new ValueChange(this.getValue(constMapIterator.getKey(), n + 1, this.getMapCount()), object2));
                }
                constMapIterator.next();
            }
            this.fireEntriesChanged(mapAdapter);
        }
    }

    private void addMapListener(int n) {
        if (this.mapListeners == null) {
            this.mapListeners = new ArrayList(n + 2);
        }
        final ConstChangeNotifyMap constChangeNotifyMap = this.getMap(n);
        SignalListener signalListener = new SignalListener(){

            public void signalEmitted(Signal signal, Object object) {
                ConstMap constMap = (ConstMap)object;
                MapAdapter mapAdapter = new MapAdapter();
                int n = ConstChangeNotifyVectorMap.this.getMapIndex(constChangeNotifyMap);
                ConstMapIterator constMapIterator = constMap.constIterator();
                while (constMapIterator.atEntry()) {
                    Object object2 = ConstChangeNotifyVectorMap.this.getValue(constMapIterator.getKey(), 0, n);
                    if (object2 == null) {
                        ValueChange valueChange = (ValueChange)constMapIterator.getValue();
                        mapAdapter.put(constMapIterator.getKey(), valueChange.getOldValue() == null ? new ValueChange(ConstChangeNotifyVectorMap.this.getValue(constMapIterator.getKey(), n + 1, ConstChangeNotifyVectorMap.this.getMapCount()), valueChange.getNewValue()) : (valueChange.getNewValue() == null ? new ValueChange(valueChange.getOldValue(), ConstChangeNotifyVectorMap.this.getValue(constMapIterator.getKey(), n + 1, ConstChangeNotifyVectorMap.this.getMapCount())) : valueChange));
                    }
                    constMapIterator.next();
                }
                ConstChangeNotifyVectorMap.this.fireEntriesChanged(mapAdapter);
            }
        };
        this.mapListeners.add(n, signalListener);
        constChangeNotifyMap.getChangeSignal().add(signalListener);
    }

    private void removeMapListener(int n) {
        ConstChangeNotifyMap constChangeNotifyMap = this.getMap(n);
        constChangeNotifyMap.getChangeSignal().remove((SignalListener)this.mapListeners.get(n));
        this.mapListeners.remove(n);
    }

    public int getMapCount() {
        return this.vectorMap.getMapCount();
    }

    public void removeMap(int n) {
        if (this.getChangeSignalInternal().hasListeners()) {
            this.removeMapListener(n);
        }
        ConstMap constMap = this.vectorMap.removeMap(n);
        if (this.getChangeSignalInternal().hasListeners()) {
            MapAdapter mapAdapter = new MapAdapter();
            ConstMapIterator constMapIterator = constMap.constIterator();
            while (constMapIterator.atEntry()) {
                Object object = this.getValue(constMapIterator.getKey(), 0, n);
                if (object == null) {
                    Object object2 = constMapIterator.getValue();
                    mapAdapter.put(constMapIterator.getKey(), new ValueChange(object2, this.getValue(constMapIterator.getKey(), n, this.getMapCount())));
                }
                constMapIterator.next();
            }
            this.fireEntriesChanged(mapAdapter);
        }
    }

    public Object get(Object object) {
        return this.vectorMap.get(object);
    }

    public boolean containsKey(Object object) {
        return this.vectorMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.vectorMap.containsValue(object);
    }

    public boolean isEmpty() {
        return this.vectorMap.isEmpty();
    }

    public ConstChangeNotifyMap getMap(int n) {
        return (ConstChangeNotifyMap)this.vectorMap.getMap(n);
    }

    public ConstMapIterator constIterator() {
        return this.vectorMap.constIterator();
    }
}

