/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.PixelGrabber;
import java.net.URL;
import net.infonode.util.Direction;
import net.infonode.util.ImageException;
import net.infonode.util.math.Int4;

public final class ImageUtils {
    public static final Image create(String string) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(string);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final Image create(URL uRL) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final Image create(byte[] byArray) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final void waitImage(Image image) throws ImageException {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            throw new ImageException("Interrupted when creating image!");
        }
    }

    public static final int[] getPixels(Image image) throws ImageException {
        return ImageUtils.getPixels(image, 0, 0, image.getWidth(null), image.getHeight(null));
    }

    public static final int[] getPixels(Image image, int n, int n2, int n3, int n4) throws ImageException {
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new ImageException("Interrupted waiting for pixels");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new ImageException("Image fetch aborted or errored");
        }
        return nArray;
    }

    public static final int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static final int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static final int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static final int getBlue(int n) {
        return n & 0xFF;
    }

    public static final int createPixel(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int toIntColor(Int4 int4) {
        return int4.getD() << 8 & 0xFF000000 | int4.getA() & 0xFF0000 | int4.getB() >> 8 & 0xFF00 | int4.getC() >> 16 & 0xFF;
    }

    public static Int4 toInt4(Color color) {
        return new Int4(color.getRed() << 16, color.getGreen() << 16, color.getBlue() << 16, color.getAlpha() << 16);
    }

    public static Color toColor(Int4 int4) {
        return new Color(int4.getA() >> 16, int4.getB() >> 16, int4.getC() >> 16, int4.getD() >> 16);
    }

    public static final int[] createGradientPixels(Color[] colorArray, int n, int n2) {
        int[] nArray = new int[n * n2];
        ImageUtils.createGradientPixels(colorArray, n, n2, nArray);
        return nArray;
    }

    public static final int[] createGradientPixels(Color[] colorArray, int n, int n2, int[] nArray) {
        int n3 = 0;
        Int4 int4 = ImageUtils.toInt4(colorArray[0]);
        Int4 int42 = ImageUtils.toInt4(colorArray[1]);
        Int4 int43 = ImageUtils.toInt4(colorArray[2]).sub(ImageUtils.toInt4(colorArray[0])).div(n2);
        Int4 int44 = ImageUtils.toInt4(colorArray[3]).sub(ImageUtils.toInt4(colorArray[1])).div(n2);
        Int4 int45 = new Int4();
        Int4 int46 = new Int4();
        for (int i = 0; i < n2; ++i) {
            int45.set(int42).sub(int4).div(n);
            int46.set(int4);
            int n4 = n3 + n;
            while (n3 < n4) {
                nArray[n3] = ImageUtils.toIntColor(int46);
                int46.add(int45);
                ++n3;
            }
            int4.add(int43);
            int42.add(int44);
        }
        return nArray;
    }

    public static AffineTransform createTransform(Direction direction, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = bl ? -1 : 1;
        int n8 = n6 = bl2 ? -1 : 1;
        int n9 = direction == Direction.RIGHT ? n7 : (n5 = direction == Direction.LEFT ? -n7 : 0);
        int n10 = direction == Direction.DOWN ? -n6 : (n4 = direction == Direction.UP ? n6 : 0);
        int n11 = direction == Direction.DOWN ? n7 : (n3 = direction == Direction.UP ? -n7 : 0);
        int n12 = direction == Direction.RIGHT ? n6 : (direction == Direction.LEFT ? -n6 : 0);
        return new AffineTransform(n5, n3, n4, n12, n5 == -1 ? (float)n : (n4 == -1 ? (float)n2 : 0.0f), n3 == -1 ? (float)n : (n12 == -1 ? (float)n2 : 0.0f));
    }
}

