/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.hover;

import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TitledTabTabbedPanelHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private boolean applied = false;
    private boolean onlyHighlighted;
    private TabAdapter tabListener = new TabAdapter(){

        public void tabHighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getCurrentTab() != null && TitledTabTabbedPanelHoverAction.this.onlyHighlighted) {
                TitledTabTabbedPanelHoverAction.this.applyTabbedPanel(tabStateChangedEvent.getCurrentTab().getTabbedPanel());
            }
        }

        public void tabDehighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getPreviousTab() != null && TitledTabTabbedPanelHoverAction.this.onlyHighlighted) {
                TitledTabTabbedPanelHoverAction.this.removeTabbedPanel(tabStateChangedEvent.getPreviousTab().getTabbedPanel());
            }
        }
    };

    public TitledTabTabbedPanelHoverAction() {
        this(new TitledTabProperties(), new TabbedPanelProperties());
    }

    public TitledTabTabbedPanelHoverAction(boolean bl) {
        this(new TitledTabProperties(), new TabbedPanelProperties(), bl);
    }

    public TitledTabTabbedPanelHoverAction(TitledTabProperties titledTabProperties, TabbedPanelProperties tabbedPanelProperties) {
        this(titledTabProperties, tabbedPanelProperties, false);
    }

    public TitledTabTabbedPanelHoverAction(TitledTabProperties titledTabProperties, TabbedPanelProperties tabbedPanelProperties, boolean bl) {
        this.titledTabProperties = titledTabProperties;
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.onlyHighlighted = !bl;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public void mouseEntered(HoverEvent hoverEvent) {
        TitledTab titledTab = (TitledTab)hoverEvent.getSource();
        if (this.onlyHighlighted) {
            titledTab.addTabListener(this.tabListener);
            if (titledTab.isHighlighted()) {
                this.applyTabbedPanel(titledTab.getTabbedPanel());
            }
        } else {
            this.applyTabbedPanel(titledTab.getTabbedPanel());
        }
        titledTab.getProperties().addSuperObject(this.titledTabProperties);
    }

    public void mouseExited(HoverEvent hoverEvent) {
        TitledTab titledTab = (TitledTab)hoverEvent.getSource();
        this.removeTabbedPanel(titledTab.getTabbedPanel());
        if (this.onlyHighlighted) {
            titledTab.removeTabListener(this.tabListener);
        }
        titledTab.getProperties().removeSuperObject(this.titledTabProperties);
    }

    private void applyTabbedPanel(TabbedPanel tabbedPanel) {
        if (!this.applied) {
            tabbedPanel.getProperties().addSuperObject(this.tabbedPanelProperties);
            this.applied = true;
        }
    }

    private void removeTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.applied) {
            tabbedPanel.getProperties().removeSuperObject(this.tabbedPanelProperties);
            this.applied = false;
        }
    }
}

