/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.draggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.ScrollButtonBox;
import net.infonode.gui.ScrollButtonBoxListener;
import net.infonode.gui.ScrollableBox;
import net.infonode.gui.ScrollableBoxListener;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.draggable.DraggableComponentBoxListener;
import net.infonode.gui.draggable.DraggableComponentEvent;
import net.infonode.gui.draggable.DraggableComponentListener;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;

public class DraggableComponentBox
extends SimplePanel {
    private final boolean componentBoxEnabled = true;
    private final JComponent componentBox;
    private JComponent componentContainer;
    private JComponent outerParentArea = this;
    private Direction componentDirection = Direction.UP;
    private boolean scrollEnabled = false;
    private boolean ensureSelectedVisible;
    private boolean autoSelect = true;
    private boolean descendingSortOrder = true;
    private boolean doReverseSort = false;
    private boolean mustSort = false;
    private int scrollOffset;
    private final int iconSize;
    private DraggableComponent selectedComponent;
    private DraggableComponent topComponent;
    private ArrayList listeners;
    private final ArrayList draggableComponentList = new ArrayList(10);
    private final ArrayList layoutOrderList = new ArrayList(10);
    private ScrollButtonBox scrollButtonBox;
    private boolean useDefaultScrollButtons = true;
    private final DraggableComponentListener draggableComponentListener = new DraggableComponentListener(){

        public void changed(DraggableComponentEvent draggableComponentEvent) {
            if (draggableComponentEvent.getType() == 0) {
                DraggableComponentBox.this.sortComponentList(!DraggableComponentBox.this.descendingSortOrder);
            }
            DraggableComponentBox.this.fireChangedEvent(draggableComponentEvent);
        }

        public void selected(DraggableComponentEvent draggableComponentEvent) {
            DraggableComponentBox.this.doSelectComponent(draggableComponentEvent.getSource());
        }

        public void dragged(DraggableComponentEvent draggableComponentEvent) {
            DraggableComponentBox.this.fireDraggedEvent(draggableComponentEvent);
        }

        public void dropped(DraggableComponentEvent draggableComponentEvent) {
            DraggableComponentBox.this.ensureSelectedVisible();
            DraggableComponentBox.this.fireDroppedEvent(draggableComponentEvent);
        }

        public void dragAborted(DraggableComponentEvent draggableComponentEvent) {
            DraggableComponentBox.this.ensureSelectedVisible();
            DraggableComponentBox.this.fireNotDroppedEvent(draggableComponentEvent);
        }
    };

    public DraggableComponentBox(int n) {
        this(n, true);
    }

    public DraggableComponentBox(int n, boolean bl) {
        this.iconSize = n;
        this.useDefaultScrollButtons = bl;
        DirectionLayout directionLayout = new DirectionLayout(this.componentDirection == Direction.UP ? Direction.RIGHT : (this.componentDirection == Direction.LEFT ? Direction.DOWN : (this.componentDirection == Direction.DOWN ? Direction.RIGHT : Direction.DOWN))){

            public Dimension minimumLayoutSize(Container container) {
                Dimension dimension = super.minimumLayoutSize(container);
                Dimension dimension2 = super.preferredLayoutSize(container);
                return DraggableComponentBox.this.componentDirection.isHorizontal() ? new Dimension(dimension2.width, dimension.height) : new Dimension(dimension.width, dimension2.height);
            }

            public void layoutContainer(Container container) {
                if (DraggableComponentBox.this != null) {
                    DraggableComponentBox.this.doSort();
                    super.layoutContainer(container);
                }
            }

            public Dimension preferredLayoutSize(Container container) {
                DraggableComponentBox.this.doSort();
                return super.preferredLayoutSize(container);
            }
        };
        directionLayout.setLayoutOrderList(this.layoutOrderList);
        this.componentBox = new SimplePanel((LayoutManager)directionLayout){

            public boolean isOptimizedDrawingEnabled() {
                return DraggableComponentBox.this != null && DraggableComponentBox.this.getComponentSpacing() >= 0;
            }
        };
        this.componentBox.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                DraggableComponentBox.this.fireChangedEvent();
            }
        });
        this.initialize();
    }

    public void addListener(DraggableComponentBoxListener draggableComponentBoxListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(draggableComponentBoxListener);
    }

    public void removeListener(DraggableComponentBoxListener draggableComponentBoxListener) {
        if (this.listeners != null) {
            this.listeners.remove(draggableComponentBoxListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public void addDraggableComponent(DraggableComponent draggableComponent) {
        this.insertDraggableComponent(draggableComponent, -1);
    }

    public void insertDraggableComponent(DraggableComponent draggableComponent, int n) {
        draggableComponent.setLayoutOrderList(this.layoutOrderList);
        draggableComponent.addListener(this.draggableComponentListener);
        if (n < 0) {
            this.layoutOrderList.add(draggableComponent.getComponent());
            this.componentBox.add(draggableComponent.getComponent());
        } else {
            this.layoutOrderList.add(n, draggableComponent.getComponent());
            this.componentBox.add((Component)draggableComponent.getComponent(), n);
        }
        this.sortComponentList(!this.descendingSortOrder);
        this.draggableComponentList.add(draggableComponent);
        draggableComponent.setOuterParentArea(this.outerParentArea);
        this.componentBox.revalidate();
        this.fireAddedEvent(draggableComponent);
        if (this.autoSelect && this.layoutOrderList.size() == 1 && this.selectedComponent == null && draggableComponent.isEnabled()) {
            this.doSelectComponent(draggableComponent);
        }
        this.updateScrollButtons();
    }

    private void updateScrollButtons() {
        if (this.scrollButtonBox != null) {
            ScrollableBox scrollableBox = (ScrollableBox)this.componentContainer;
            this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
            this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
        }
    }

    public void insertDraggableComponent(DraggableComponent draggableComponent, Point point) {
        int n = this.getComponentIndexAtPoint(point);
        if (n != -1 && this.layoutOrderList.size() > 0) {
            this.insertDraggableComponent(draggableComponent, n);
        } else {
            this.insertDraggableComponent(draggableComponent, -1);
        }
    }

    public void selectDraggableComponent(DraggableComponent draggableComponent) {
        if (draggableComponent == null) {
            if (this.selectedComponent != null) {
                DraggableComponent draggableComponent2 = this.selectedComponent;
                this.selectedComponent = null;
                this.fireSelectedEvent(this.selectedComponent, draggableComponent2);
            }
        } else {
            draggableComponent.select();
        }
    }

    public void removeDraggableComponent(DraggableComponent draggableComponent) {
        if (draggableComponent != null && this.draggableComponentList.contains(draggableComponent)) {
            int n = this.layoutOrderList.indexOf(draggableComponent.getComponent());
            draggableComponent.removeListener(this.draggableComponentListener);
            if (draggableComponent == this.topComponent) {
                this.topComponent = null;
            }
            if (this.layoutOrderList.size() > 1 && this.selectedComponent != null) {
                if (this.selectedComponent == draggableComponent) {
                    if (this.autoSelect) {
                        int n2 = this.findSelectableComponentIndex(n);
                        if (n2 > -1) {
                            this.selectDraggableComponent(this.findDraggableComponent((Component)this.layoutOrderList.get(n2)));
                        } else {
                            this.selectedComponent = null;
                        }
                    } else {
                        this.selectDraggableComponent(null);
                    }
                }
            } else if (this.selectedComponent != null) {
                DraggableComponent draggableComponent2 = this.selectedComponent;
                this.selectedComponent = null;
                this.fireSelectedEvent(this.selectedComponent, draggableComponent2);
            }
            this.draggableComponentList.remove(draggableComponent);
            this.layoutOrderList.remove(draggableComponent.getComponent());
            this.componentBox.remove(draggableComponent.getComponent());
            this.componentBox.revalidate();
            draggableComponent.setLayoutOrderList(null);
            this.sortComponentList(!this.descendingSortOrder);
            this.updateScrollButtons();
            this.fireRemovedEvent(draggableComponent);
        }
    }

    public boolean containsDraggableComponent(DraggableComponent draggableComponent) {
        return this.draggableComponentList.contains(draggableComponent);
    }

    public DraggableComponent getSelectedDraggableComponent() {
        return this.selectedComponent;
    }

    public int getDraggableComponentCount() {
        return this.layoutOrderList.size();
    }

    public DraggableComponent getDraggableComponentAt(int n) {
        return n < this.layoutOrderList.size() ? this.findDraggableComponent((Component)this.layoutOrderList.get(n)) : null;
    }

    public int getDraggableComponentIndex(DraggableComponent draggableComponent) {
        return this.layoutOrderList.indexOf(draggableComponent.getComponent());
    }

    public Object[] getDraggableComponents() {
        return this.draggableComponentList.toArray();
    }

    public Component[] getBoxComponents() {
        return this.componentBox.getComponents();
    }

    public boolean getDepthSortOrder() {
        return this.descendingSortOrder;
    }

    public void setDepthSortOrder(boolean bl) {
        if (bl != this.descendingSortOrder) {
            this.descendingSortOrder = bl;
            this.sortComponentList(!bl);
            this.doSort();
        }
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    public void setScrollEnabled(boolean bl) {
        if (bl != this.scrollEnabled) {
            this.scrollEnabled = bl;
            this.initialize();
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int n) {
        if (n != this.scrollOffset) {
            this.scrollOffset = n;
            if (this.scrollEnabled) {
                ((ScrollableBox)this.componentContainer).setScrollOffset(n);
            }
        }
    }

    public int getComponentSpacing() {
        return this.getDirectionLayout().getComponentSpacing();
    }

    public void setComponentSpacing(int n) {
        if (n != this.getDirectionLayout().getComponentSpacing()) {
            if (this.getComponentSpacing() < 0 && n >= 0) {
                DraggableComponent draggableComponent = this.topComponent;
                this.sortComponentList(false);
                this.topComponent = draggableComponent;
            }
            this.getDirectionLayout().setComponentSpacing(n);
            this.sortComponentList(!this.descendingSortOrder);
            this.componentBox.revalidate();
        }
    }

    public boolean isEnsureSelectedVisible() {
        return this.ensureSelectedVisible;
    }

    public void setEnsureSelectedVisible(boolean bl) {
        this.ensureSelectedVisible = bl;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean bl) {
        this.autoSelect = bl;
    }

    public Direction getComponentDirection() {
        return this.componentDirection;
    }

    public void setComponentDirection(Direction direction) {
        if (direction != this.componentDirection) {
            this.componentDirection = direction;
            this.getDirectionLayout().setDirection(direction == Direction.UP ? Direction.RIGHT : (direction == Direction.LEFT ? Direction.DOWN : (direction == Direction.DOWN ? Direction.RIGHT : Direction.DOWN)));
            if (this.scrollEnabled) {
                this.scrollButtonBox.setVertical(direction.isHorizontal());
                ((ScrollableBox)this.componentContainer).setVertical(direction.isHorizontal());
            }
        }
    }

    public void setTopComponent(DraggableComponent draggableComponent) {
        if (draggableComponent != this.topComponent) {
            this.topComponent = draggableComponent;
            this.sortComponentList(!this.descendingSortOrder);
        }
    }

    public ScrollButtonBox getScrollButtonBox() {
        return this.scrollButtonBox;
    }

    public JComponent getOuterParentArea() {
        return this.outerParentArea;
    }

    public void setOuterParentArea(JComponent jComponent) {
        this.outerParentArea = jComponent;
    }

    public void dragDraggableComponent(DraggableComponent draggableComponent, Point point) {
        if (this.draggableComponentList.contains(draggableComponent)) {
            draggableComponent.drag(SwingUtilities.convertPoint(this, point, draggableComponent.getComponent()));
        }
    }

    public Dimension getMaximumSize() {
        if (this.scrollEnabled) {
            return this.getPreferredSize();
        }
        if (this.componentDirection == Direction.LEFT || this.componentDirection == Direction.RIGHT) {
            return new Dimension((int)this.getPreferredSize().getWidth(), (int)super.getMaximumSize().getHeight());
        }
        return new Dimension((int)super.getMaximumSize().getWidth(), (int)this.getPreferredSize().getHeight());
    }

    public Dimension getInnerSize() {
        boolean bl = this.mustSort;
        this.mustSort = false;
        Dimension dimension = this.scrollEnabled ? this.componentBox.getPreferredSize() : this.componentBox.getSize();
        this.mustSort = bl;
        return dimension;
    }

    public void scrollToVisible(final DraggableComponent draggableComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DraggableComponentBox.this.scrollEnabled) {
                    ((ScrollableBox)DraggableComponentBox.this.componentContainer).ensureVisible(DraggableComponentBox.this.layoutOrderList.indexOf(draggableComponent.getComponent()));
                }
            }
        });
    }

    private void setIgnoreAddRemoveNotify(boolean bl) {
        for (int i = 0; i < this.draggableComponentList.size(); ++i) {
            ((DraggableComponent)this.draggableComponentList.get(i)).setIgnoreAddNotify(bl);
        }
    }

    private void doSort() {
        if (this.mustSort && this.getComponentSpacing() < 0 && this.componentBox.getComponentCount() > 0) {
            this.setIgnoreAddRemoveNotify(true);
            this.mustSort = false;
            JComponent jComponent = this.topComponent != null ? this.topComponent.getComponent() : null;
            int n = 0;
            if (jComponent != null) {
                if (this.componentBox.getComponent(0) != jComponent) {
                    this.componentBox.remove(jComponent);
                    this.componentBox.add((Component)jComponent, n);
                }
                ++n;
            }
            int n2 = 0;
            int n3 = this.layoutOrderList.size();
            for (int i = 0; i < n3; ++i) {
                Component component = (Component)this.layoutOrderList.get(this.doReverseSort ? n3 - i - 1 : i);
                if (component == jComponent) continue;
                if (this.componentBox.getComponent(n) != component) {
                    ++n2;
                    this.componentBox.remove(component);
                    this.componentBox.add(component, n);
                }
                ++n;
            }
            this.setIgnoreAddRemoveNotify(false);
        }
    }

    private void sortComponentList(boolean bl) {
        this.doReverseSort = bl;
        this.mustSort = true;
    }

    private int getComponentIndexAtPoint(Point point) {
        JComponent jComponent = null;
        Point point2 = SwingUtilities.convertPoint(this, point, this.componentBox);
        Point point3 = SwingUtilities.convertPoint(this.componentBox, point, this.outerParentArea);
        if (this.outerParentArea.contains(point3)) {
            jComponent = (JComponent)ComponentUtil.getChildAtLine(this.componentBox, point2, this.getDirectionLayout().getDirection().isHorizontal());
        }
        return this.layoutOrderList.indexOf(jComponent);
    }

    private void doSelectComponent(DraggableComponent draggableComponent) {
        if (this.selectedComponent != null) {
            DraggableComponent draggableComponent2 = this.selectedComponent;
            this.selectedComponent = draggableComponent;
            this.ensureSelectedVisible();
            this.fireSelectedEvent(this.selectedComponent, draggableComponent2);
        } else {
            this.selectedComponent = draggableComponent;
            this.ensureSelectedVisible();
            this.fireSelectedEvent(this.selectedComponent, null);
        }
    }

    private int findSelectableComponentIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.layoutOrderList.size(); ++i) {
            if (!this.findDraggableComponent((Component)this.layoutOrderList.get(i)).isEnabled() || i == n) continue;
            int n3 = n2;
            n2 = i;
            if (n3 < n && n2 > n) {
                return n2;
            }
            if (n3 <= n || n2 <= n) continue;
            return n3;
        }
        return n2;
    }

    private DraggableComponent findDraggableComponent(Component component) {
        for (int i = 0; i < this.draggableComponentList.size(); ++i) {
            if (((DraggableComponent)this.draggableComponentList.get(i)).getComponent() != component) continue;
            return (DraggableComponent)this.draggableComponentList.get(i);
        }
        return null;
    }

    private DirectionLayout getDirectionLayout() {
        return (DirectionLayout)this.componentBox.getLayout();
    }

    private void initialize() {
        if (this.componentContainer != null) {
            this.remove(this.componentContainer);
        }
        DirectionLayout directionLayout = this.getDirectionLayout();
        directionLayout.setCompressing(!this.scrollEnabled);
        if (this.scrollEnabled) {
            this.scrollButtonBox = this.useDefaultScrollButtons ? new ScrollButtonBox(this.componentDirection.isHorizontal(), this.iconSize) : new ScrollButtonBox(this.componentDirection.isHorizontal(), null, null, null, null);
            final ScrollableBox scrollableBox = new ScrollableBox(this.componentBox, this.componentDirection.isHorizontal(), this.scrollOffset);
            scrollableBox.setLayoutOrderList(this.layoutOrderList);
            this.scrollButtonBox.addListener(new ScrollButtonBoxListener(){

                public void scrollButton1() {
                    scrollableBox.scrollLeft(1);
                }

                public void scrollButton2() {
                    scrollableBox.scrollRight(1);
                }
            });
            scrollableBox.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
                }
            });
            this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
            this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
            scrollableBox.addScrollableBoxListener(new ScrollableBoxListener(){

                public void scrolledLeft(ScrollableBox scrollableBox) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(true);
                }

                public void scrolledRight(ScrollableBox scrollableBox) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(true);
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
                }

                public void changed(ScrollableBox scrollableBox) {
                    DraggableComponentBox.this.fireChangedEvent();
                }
            });
            this.componentContainer = scrollableBox;
        } else {
            this.scrollButtonBox = null;
            this.componentContainer = this.componentBox;
        }
        this.componentContainer.setAlignmentY(0.0f);
        this.add((Component)this.componentContainer, "Center");
        this.revalidate();
    }

    private void ensureSelectedVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DraggableComponentBox.this.scrollEnabled && DraggableComponentBox.this.ensureSelectedVisible && DraggableComponentBox.this.selectedComponent != null) {
                    ((ScrollableBox)DraggableComponentBox.this.componentContainer).ensureVisible(DraggableComponentBox.this.layoutOrderList.indexOf(DraggableComponentBox.this.selectedComponent.getComponent()));
                }
            }
        });
    }

    private void fireDraggedEvent(DraggableComponentEvent draggableComponentEvent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponentEvent.getSource(), draggableComponentEvent, SwingUtilities.convertPoint(draggableComponentEvent.getSource().getComponent(), draggableComponentEvent.getMouseEvent().getPoint(), this));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentDragged(draggableComponentBoxEvent);
            }
        }
    }

    private void fireDroppedEvent(DraggableComponentEvent draggableComponentEvent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponentEvent.getSource(), draggableComponentEvent, SwingUtilities.convertPoint(draggableComponentEvent.getSource().getComponent(), draggableComponentEvent.getMouseEvent().getPoint(), this));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentDropped(draggableComponentBoxEvent);
            }
        }
    }

    private void fireNotDroppedEvent(DraggableComponentEvent draggableComponentEvent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponentEvent.getSource(), draggableComponentEvent);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentDragAborted(draggableComponentBoxEvent);
            }
        }
    }

    private void fireSelectedEvent(DraggableComponent draggableComponent, DraggableComponent draggableComponent2) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponent, draggableComponent2);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentSelected(draggableComponentBoxEvent);
            }
        }
    }

    private void fireAddedEvent(DraggableComponent draggableComponent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponent);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentAdded(draggableComponentBoxEvent);
            }
        }
    }

    private void fireRemovedEvent(DraggableComponent draggableComponent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponent);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).componentRemoved(draggableComponentBoxEvent);
            }
        }
    }

    private void fireChangedEvent(DraggableComponentEvent draggableComponentEvent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this, draggableComponentEvent.getSource(), draggableComponentEvent);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).changed(draggableComponentBoxEvent);
            }
        }
    }

    private void fireChangedEvent() {
        if (this.listeners != null) {
            DraggableComponentBoxEvent draggableComponentBoxEvent = new DraggableComponentBoxEvent(this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentBoxListener)objectArray[i]).changed(draggableComponentBoxEvent);
            }
        }
    }
}

