/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.draggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.draggable.DraggableComponentEvent;
import net.infonode.gui.draggable.DraggableComponentListener;

public class DraggableComponent {
    private final JComponent component;
    private JComponent[] eventComponents;
    private boolean reorderEnabled = true;
    private boolean enabled = true;
    private boolean reorderRestoreOnDrag;
    private boolean detectOuterAreaAsLine = true;
    private boolean enableInsideDrag;
    private boolean selectOnMousePress;
    private boolean mousePressed;
    private boolean dragEventFired;
    private boolean dragStarted;
    private boolean ignoreAddNotify = false;
    private int dragIndex;
    private int dragFromIndex;
    private int abortDragKeyCode = 27;
    private ArrayList layoutOrderList;
    private ArrayList listeners;
    private JComponent outerParentArea;
    private final KeyEventDispatcher abortDragKeyDispatcher = new KeyEventDispatcher(){

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (DraggableComponent.this.mousePressed && keyEvent.getKeyCode() == DraggableComponent.this.abortDragKeyCode) {
                if (keyEvent.getID() == 401) {
                    DraggableComponent.this.dragCompleted(null);
                }
                return true;
            }
            return false;
        }
    };
    private final MouseInputListener mouseInputListener = new MouseInputAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            DraggableComponent.this.pressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DraggableComponent.this.released(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            DraggableComponent.this.dragged(mouseEvent);
        }
    };

    public DraggableComponent(JComponent jComponent) {
        this(jComponent, jComponent);
    }

    public DraggableComponent(JComponent jComponent, JComponent jComponent2) {
        this(jComponent, new JComponent[]{jComponent2});
    }

    public DraggableComponent(JComponent jComponent, JComponent[] jComponentArray) {
        this.component = jComponent;
        jComponent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DraggableComponent.this.fireChangedEvent(-1);
            }
        });
        this.setEventComponents(jComponentArray);
    }

    public void addListener(DraggableComponentListener draggableComponentListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(draggableComponentListener);
    }

    public void removeListener(DraggableComponentListener draggableComponentListener) {
        if (this.listeners != null) {
            this.listeners.remove(draggableComponentListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JComponent[] getEventComponents() {
        return this.eventComponents;
    }

    public void setEventComponents(JComponent[] jComponentArray) {
        int n;
        if (this.eventComponents != null) {
            for (n = 0; n < this.eventComponents.length; ++n) {
                this.eventComponents[n].removeMouseListener(this.mouseInputListener);
                this.eventComponents[n].removeMouseMotionListener(this.mouseInputListener);
            }
        }
        this.eventComponents = jComponentArray;
        if (this.eventComponents != null) {
            for (n = 0; n < this.eventComponents.length; ++n) {
                this.eventComponents[n].addMouseListener(this.mouseInputListener);
                this.eventComponents[n].addMouseMotionListener(this.mouseInputListener);
            }
        }
    }

    public int getAbortDragKeyCode() {
        return this.abortDragKeyCode;
    }

    public void setAbortDragKeyCode(int n) {
        this.abortDragKeyCode = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireChangedEvent(bl ? 3 : 4);
        }
    }

    public boolean isReorderEnabled() {
        return this.reorderEnabled;
    }

    public void setReorderEnabled(boolean bl) {
        this.reorderEnabled = bl;
    }

    public boolean isReorderRestoreOnDrag() {
        return this.reorderRestoreOnDrag;
    }

    public void setReorderRestoreOnDrag(boolean bl) {
        this.reorderRestoreOnDrag = bl;
    }

    public boolean isDetectOuterAreaAsLine() {
        return this.detectOuterAreaAsLine;
    }

    public void setDetectOuterAreaAsLine(boolean bl) {
        this.detectOuterAreaAsLine = bl;
    }

    public boolean isEnableInsideDrag() {
        return this.enableInsideDrag;
    }

    public void setEnableInsideDrag(boolean bl) {
        this.enableInsideDrag = bl;
    }

    public boolean isSelectOnMousePress() {
        return this.selectOnMousePress;
    }

    public void setSelectOnMousePress(boolean bl) {
        this.selectOnMousePress = bl;
    }

    public void drag(Point point) {
        if (this.enabled) {
            this.dragFromIndex = this.dragIndex = this.getComponentIndex(this.component);
            this.doDrag(point);
        }
    }

    public void abortDrag() {
        if (this.dragStarted) {
            this.dragCompleted(null);
        }
    }

    public void setLayoutOrderList(ArrayList arrayList) {
        this.layoutOrderList = arrayList;
    }

    public void select() {
        if (this.enabled) {
            this.fireSelectedEvent();
        }
    }

    public void setOuterParentArea(JComponent jComponent) {
        this.outerParentArea = jComponent;
    }

    public boolean isIgnoreAddNotify() {
        return this.ignoreAddNotify;
    }

    public void setIgnoreAddNotify(boolean bl) {
        this.ignoreAddNotify = bl;
    }

    private void pressed(MouseEvent mouseEvent) {
        if (this.enabled && mouseEvent.getButton() == 1) {
            if (this.selectOnMousePress && !mouseEvent.isShiftDown()) {
                this.select();
            }
            this.dragStarted = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.abortDragKeyDispatcher);
            this.mousePressed = true;
            this.dragFromIndex = this.dragIndex = this.getComponentIndex(this.component);
            this.fireChangedEvent(1);
        }
    }

    private void released(MouseEvent mouseEvent) {
        if (this.mousePressed) {
            if (mouseEvent.getButton() == 1) {
                this.dragCompleted(mouseEvent);
            } else {
                this.dragCompleted(null);
                mouseEvent.consume();
            }
        }
    }

    private void dragged(MouseEvent mouseEvent) {
        if (this.enabled && this.mousePressed) {
            Point point = SwingUtilities.convertPoint((JComponent)mouseEvent.getSource(), mouseEvent.getPoint(), this.component);
            if (this.dragStarted || this.enableInsideDrag || !this.component.contains(point)) {
                if (this.reorderEnabled) {
                    this.doDrag(point);
                } else {
                    this.dragStarted = true;
                }
                this.fireDraggedEvent(EventUtil.convert(mouseEvent, this.component, point));
            }
        }
    }

    private void dragCompleted(MouseEvent mouseEvent) {
        this.mousePressed = false;
        this.dragStarted = false;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.abortDragKeyDispatcher);
        if (mouseEvent == null) {
            this.restoreComponentOrder();
            this.fireNotDroppedEvent();
        } else if (!this.checkParentContains(SwingUtilities.convertPoint((JComponent)mouseEvent.getSource(), mouseEvent.getPoint(), this.component.getParent()))) {
            this.restoreComponentOrder();
            this.fireDroppedEvent(EventUtil.convert(mouseEvent, this.component));
        } else {
            this.fireDroppedEvent(EventUtil.convert(mouseEvent, this.component));
            if (!this.selectOnMousePress && !mouseEvent.isShiftDown()) {
                this.fireSelectedEvent();
            }
        }
        this.fireChangedEvent(2);
    }

    private void updateParent() {
        if (this.component.getParent() != null) {
            ComponentUtil.validate(this.component.getParent());
        }
    }

    private void doDrag(Point point) {
        this.dragStarted = true;
        JComponent jComponent = (JComponent)this.component.getParent();
        if (jComponent.getComponentCount() == 1) {
            return;
        }
        Point point2 = SwingUtilities.convertPoint(this.component, point, jComponent);
        int n = this.getMoveComponentIndex(point2);
        if (n != -1) {
            int n2;
            int n3;
            int n4;
            n = Math.min(n, jComponent.getComponentCount() - 1);
            JComponent jComponent2 = this.getComponent(jComponent, this.dragIndex);
            if (this.isVerticalDrag()) {
                n4 = ((Component)jComponent2).getHeight();
                n3 = (int)SwingUtilities.convertPoint(jComponent, point2, this.getComponent(jComponent, n)).getY();
                n2 = this.getComponent(jComponent, n).getHeight();
            } else {
                n4 = ((Component)jComponent2).getWidth();
                n3 = (int)SwingUtilities.convertPoint(jComponent, point2, this.getComponent(jComponent, n)).getX();
                n2 = this.getComponent(jComponent, n).getWidth();
            }
            if (n > this.dragIndex && n2 - n3 > n4 || (this.dragIndex == -1 || n < this.dragIndex) && n3 > n4) {
                return;
            }
            if (this.dragIndex != -1 && this.dragIndex != n) {
                this.removeComponent(jComponent, jComponent2, this.dragIndex);
                this.addComponent(jComponent, jComponent2, n);
                this.fireChangedEvent(0);
            }
        }
        if (n < 0) {
            this.restoreComponentOrder();
        } else {
            this.dragIndex = n;
        }
    }

    private boolean isVerticalDrag() {
        JComponent jComponent = (JComponent)this.component.getParent();
        if (jComponent.getComponentCount() > 1) {
            return this.getComponent(jComponent, 0).getY() < this.getComponent(jComponent, 1).getY();
        }
        return false;
    }

    private boolean checkParentContains(Point point) {
        if (this.outerParentArea == null) {
            return this.component.getParent().contains(point);
        }
        Point point2 = SwingUtilities.convertPoint(this.component.getParent(), point, this.outerParentArea);
        if (this.detectOuterAreaAsLine) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.component.getParent().contains(point) || this.outerParentArea.contains(point2) && (this.isVerticalDrag() ? point2.getX() >= (double)insets.left && point2.getX() < (double)(this.outerParentArea.getWidth() - insets.right) : point2.getY() >= (double)insets.top && point2.getY() < (double)(this.outerParentArea.getHeight() - insets.bottom));
        }
        return this.component.getParent().contains(point) || this.outerParentArea.contains(point2);
    }

    private int getMoveComponentIndex(Point point) {
        JComponent jComponent = (JComponent)this.component.getParent();
        if (this.checkParentContains(point)) {
            boolean bl = this.isVerticalDrag();
            for (int i = 0; i < jComponent.getComponentCount() - 1; ++i) {
                Point point2 = this.getComponent(jComponent, i + 1).getLocation();
                if (!(bl ? point.getY() >= 0.0 && point.getY() < point2.getY() : point.getX() >= 0.0 && point.getX() < point2.getX())) continue;
                return i;
            }
            if (this.dragIndex == -1) {
                return jComponent.getComponentCount();
            }
            if (bl) {
                return point.getY() < 0.0 ? 0 : jComponent.getComponentCount() - 1;
            }
            return point.getX() < 0.0 ? 0 : jComponent.getComponentCount() - 1;
        }
        return -1;
    }

    private JComponent getComponent(Container container, int n) {
        if (this.layoutOrderList != null) {
            return (JComponent)this.layoutOrderList.get(n);
        }
        return (JComponent)container.getComponent(n);
    }

    private int getComponentIndex(Component component) {
        if (this.layoutOrderList != null) {
            return this.layoutOrderList.indexOf(component);
        }
        return ComponentUtil.getComponentIndex(component);
    }

    private void addComponent(Container container, Component component, int n) {
        if (this.layoutOrderList != null) {
            this.layoutOrderList.add(n, component);
            container.add(component, n);
        } else {
            container.add(component, n);
        }
        this.revalidateComponentTree((JComponent)component);
    }

    private void removeComponent(Container container, Component component, int n) {
        this.revalidateComponentTree((JComponent)component);
        if (this.layoutOrderList != null) {
            if (n < 0) {
                this.layoutOrderList.remove(component);
                container.remove(component);
            } else {
                Component component2 = (Component)this.layoutOrderList.get(n);
                this.layoutOrderList.remove(n);
                container.remove(component2);
            }
        } else if (n < 0) {
            container.remove(component);
        } else {
            container.remove(n);
        }
    }

    private void revalidateComponentTree(JComponent jComponent) {
        Container container = jComponent.getParent();
        int n = ComponentUtil.getComponentIndex(jComponent);
        if (n > 0) {
            this.doRevalidateComponentTree((JComponent)container.getComponent(n - 1));
        }
        this.doRevalidateComponentTree(jComponent);
        if (n < container.getComponentCount() - 1) {
            this.doRevalidateComponentTree((JComponent)container.getComponent(n + 1));
        }
    }

    private void doRevalidateComponentTree(JComponent jComponent) {
        jComponent.revalidate();
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.doRevalidateComponentTree((JComponent)jComponent.getComponent(i));
        }
    }

    private void restoreComponentOrder() {
        if (this.reorderEnabled && this.dragIndex != -1 && this.dragFromIndex != -1 && this.dragIndex != this.dragFromIndex) {
            Container container = this.component.getParent();
            JComponent jComponent = this.getComponent(container, this.dragIndex);
            this.removeComponent(container, jComponent, -1);
            this.dragIndex = this.dragFromIndex;
            this.addComponent(container, jComponent, this.dragIndex);
            this.fireChangedEvent(0);
        }
    }

    private void fireChangedEvent(int n) {
        this.updateParent();
        if (this.listeners != null) {
            DraggableComponentEvent draggableComponentEvent = new DraggableComponentEvent(this, n);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentListener)objectArray[i]).changed(draggableComponentEvent);
            }
        }
    }

    private void fireSelectedEvent() {
        this.updateParent();
        if (this.listeners != null) {
            DraggableComponentEvent draggableComponentEvent = new DraggableComponentEvent(this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentListener)objectArray[i]).selected(draggableComponentEvent);
            }
        }
    }

    private void fireDraggedEvent(MouseEvent mouseEvent) {
        this.dragEventFired = true;
        if (this.listeners != null) {
            DraggableComponentEvent draggableComponentEvent = new DraggableComponentEvent(this, mouseEvent);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DraggableComponentListener)objectArray[i]).dragged(draggableComponentEvent);
            }
        }
    }

    private void fireDroppedEvent(MouseEvent mouseEvent) {
        this.updateParent();
        if (this.dragEventFired) {
            this.dragEventFired = false;
            if (this.listeners != null) {
                DraggableComponentEvent draggableComponentEvent = new DraggableComponentEvent(this, mouseEvent);
                Object[] objectArray = this.listeners.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DraggableComponentListener)objectArray[i]).dropped(draggableComponentEvent);
                }
            }
        }
    }

    private void fireNotDroppedEvent() {
        this.updateParent();
        if (this.dragEventFired) {
            this.dragEventFired = false;
            if (this.listeners != null) {
                DraggableComponentEvent draggableComponentEvent = new DraggableComponentEvent(this);
                Object[] objectArray = this.listeners.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DraggableComponentListener)objectArray[i]).dragAborted(draggableComponentEvent);
                }
            }
        }
    }
}

