/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import net.infonode.gui.ButtonFactory;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.ScrollButtonBoxListener;
import net.infonode.gui.icon.button.ArrowIcon;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;

public class ScrollButtonBox
extends SimplePanel {
    private AbstractButton upButton;
    private AbstractButton downButton;
    private AbstractButton leftButton;
    private AbstractButton rightButton;
    private boolean button1Enabled;
    private boolean button2Enabled;
    private boolean vertical;
    private ArrayList listeners;
    private ActionListener button1Listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ScrollButtonBox.this.fireButton1();
        }
    };
    private ActionListener button2Listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ScrollButtonBox.this.fireButton2();
        }
    };

    public ScrollButtonBox(boolean bl, int n) {
        this(bl, ButtonFactory.createFlatHighlightButton(new ArrowIcon(n, Direction.UP), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(n, Direction.DOWN), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(n, Direction.LEFT), "", 0, null), ButtonFactory.createFlatHighlightButton(new ArrowIcon(n, Direction.RIGHT), "", 0, null));
    }

    public ScrollButtonBox(boolean bl, AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3, AbstractButton abstractButton4) {
        this.vertical = bl;
        this.setLayout(new DirectionLayout(bl ? Direction.DOWN : Direction.RIGHT));
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    ScrollButtonBox.this.fireButton1();
                } else {
                    ScrollButtonBox.this.fireButton2();
                }
            }
        });
        this.setButtons(abstractButton, abstractButton2, abstractButton3, abstractButton4);
    }

    public void setButton1Enabled(boolean bl) {
        this.button1Enabled = bl;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(0)).setEnabled(bl);
        }
    }

    public void setButton2Enabled(boolean bl) {
        this.button2Enabled = bl;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(1)).setEnabled(bl);
        }
    }

    public boolean isButton1Enabled() {
        return this.button1Enabled;
    }

    public boolean isButton2Enabled() {
        return this.button2Enabled;
    }

    public void addListener(ScrollButtonBoxListener scrollButtonBoxListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(scrollButtonBoxListener);
    }

    public void removeListener(ScrollButtonBoxListener scrollButtonBoxListener) {
        if (this.listeners != null) {
            this.listeners.remove(scrollButtonBoxListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        if (bl != this.vertical) {
            this.vertical = bl;
            this.initialize();
        }
    }

    public void setButtons(AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3, AbstractButton abstractButton4) {
        if (abstractButton != this.upButton || abstractButton2 != this.downButton || abstractButton3 != this.leftButton || abstractButton4 != this.rightButton) {
            this.upButton = abstractButton;
            this.downButton = abstractButton2;
            this.leftButton = abstractButton3;
            this.rightButton = abstractButton4;
            this.initialize();
        }
    }

    public AbstractButton getUpButton() {
        return this.upButton;
    }

    public AbstractButton getDownButton() {
        return this.downButton;
    }

    public AbstractButton getLeftButton() {
        return this.leftButton;
    }

    public AbstractButton getRightButton() {
        return this.rightButton;
    }

    private void fireButton1() {
        if (this.listeners != null) {
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((ScrollButtonBoxListener)objectArray[i]).scrollButton1();
            }
        }
    }

    private void fireButton2() {
        if (this.listeners != null) {
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((ScrollButtonBoxListener)objectArray[i]).scrollButton2();
            }
        }
    }

    private void initialize() {
        AbstractButton abstractButton;
        AbstractButton abstractButton2;
        if (this.getComponentCount() > 0) {
            ((AbstractButton)this.getComponent(0)).removeActionListener(this.button1Listener);
            ((AbstractButton)this.getComponent(1)).removeActionListener(this.button2Listener);
            this.removeAll();
        }
        ((DirectionLayout)this.getLayout()).setDirection(this.vertical ? Direction.DOWN : Direction.RIGHT);
        if (this.vertical) {
            abstractButton2 = this.upButton;
            abstractButton = this.downButton;
        } else {
            abstractButton2 = this.leftButton;
            abstractButton = this.rightButton;
        }
        if (abstractButton2 != null && abstractButton != null) {
            this.add(abstractButton2);
            this.add(abstractButton);
            abstractButton2.setFocusable(false);
            abstractButton.setFocusable(false);
            abstractButton2.setEnabled(this.button1Enabled);
            abstractButton.setEnabled(this.button2Enabled);
            abstractButton2.addActionListener(this.button1Listener);
            abstractButton.addActionListener(this.button2Listener);
        }
        if (this.getParent() != null) {
            ComponentUtil.validate(this.getParent());
        }
    }
}

