/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme.internal.laftheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.docking.View;
import net.infonode.docking.internal.ViewTitleBar;
import net.infonode.docking.theme.internal.laftheme.TitleBarUIListener;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.tabbedpanel.theme.internal.laftheme.SizeIcon;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;

public class TitleBarUI {
    private static final int NUM_FADE_COLORS = 25;
    private static final int BUTTON_OFFSET = 2;
    private static final int RIGHT_INSET = 4;
    private final boolean showing = true;
    private boolean enabled;
    private final DynamicUIManagerListener uiListener = new DynamicUIManagerListener(){

        public void lookAndFeelChanged() {
            TitleBarUI.this.doUpdate();
        }

        public void propertiesChanging() {
            TitleBarUI.this.listener.updating();
        }

        public void propertiesChanged() {
            TitleBarUI.this.doUpdate();
        }

        public void lookAndFeelChanging() {
            TitleBarUI.this.listener.updating();
        }
    };
    private final Color[] fadeSelectedColors = new Color[25];
    private final Color[] fadeNormalColors = new Color[25];
    private final IFrame iFrame = new IFrame();
    private JFrame frame;
    private Dimension reportedMinimumSize;
    private Dimension minimumSize;
    private Insets iFrameInsets;
    private Color inactiveBackgroundColor;
    private Color activeBackgroundColor;
    private Color foundBackgroundColor;
    private boolean skipIFrame = false;
    private final ComponentPainter activeComponentPainter = new ComponentPainter(){

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
            graphics.translate(-n, -n2);
            TitleBarUI.this.paintTitleBar(component, graphics, true, n3, n4, Direction.UP);
            graphics.translate(n, n2);
        }

        public boolean isOpaque(Component component) {
            return false;
        }

        public Color getColor(Component component) {
            return TitleBarUI.this.getActiveBackgroundColor();
        }
    };
    private final ComponentPainter inactiveComponentPainter = new ComponentPainter(){

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
            graphics.translate(-n, -n2);
            TitleBarUI.this.paintTitleBar(component, graphics, false, n3, n4, Direction.UP);
            graphics.translate(n, n2);
        }

        public boolean isOpaque(Component component) {
            return false;
        }

        public Color getColor(Component component) {
            return TitleBarUI.this.getInactiveBackgroundColor();
        }
    };
    private final TitleBarUIListener listener;

    public TitleBarUI(TitleBarUIListener titleBarUIListener, boolean bl) {
        this.enabled = bl;
        this.listener = titleBarUIListener;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void dispose() {
        DynamicUIManager.getInstance().removePrioritizedListener(this.uiListener);
        this.frame.removeAll();
        this.frame.dispose();
    }

    public void init() {
        DynamicUIManager.getInstance().addPrioritizedListener(this.uiListener);
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(null);
        this.frame.getContentPane().add(this.iFrame);
        this.frame.pack();
        this.listener.updating();
        this.update();
    }

    private void doUpdate() {
        this.setEnabled(false);
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.update();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TitleBarUI.this.iFrame.setClosable(false);
                TitleBarUI.this.iFrame.setMaximizable(false);
                TitleBarUI.this.iFrame.setIconifiable(false);
                TitleBarUI.this.iFrame.setBounds(0, 0, 50, 50);
                TitleBarUI.this.iFrame.setResizable(false);
                TitleBarUI.this.iFrame.setVisible(true);
                TitleBarUI.this.iFrame.setTitle(" ");
                TitleBarUI.this.iFrame.setFrameIcon(SizeIcon.EMPTY);
                TitleBarUI.this.iFrameInsets = (Insets)TitleBarUI.this.iFrame.getInsets().clone();
                if (UIManager.getLookAndFeel().getClass().getName().indexOf(".MotifLookAndFeel") != -1) {
                    ((TitleBarUI)TitleBarUI.this).iFrameInsets.left += 19;
                }
                TitleBarUI.this.reportedMinimumSize = TitleBarUI.this.iFrame.getPreferredSize();
                TitleBarUI.this.minimumSize = new Dimension(Math.max(0, ((TitleBarUI)TitleBarUI.this).reportedMinimumSize.width - ((TitleBarUI)TitleBarUI.this).iFrameInsets.left - ((TitleBarUI)TitleBarUI.this).iFrameInsets.right), ((TitleBarUI)TitleBarUI.this).reportedMinimumSize.height - ((TitleBarUI)TitleBarUI.this).iFrameInsets.top - ((TitleBarUI)TitleBarUI.this).iFrameInsets.bottom);
                String string = UIManager.getLookAndFeel().getClass().getName();
                TitleBarUI.this.skipIFrame = string.indexOf("GTKLookAndFeel") != -1 || (string.indexOf(".WindowsLookAndFeel") != -1 || UIManager.getLookAndFeel().getClass().getName().indexOf(".Office2003LookAndFeel") != -1) && Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") != null;
                TitleBarUI.this.estimateBackgroundColors();
                TitleBarUI.this.setEnabled(true);
                TitleBarUI.this.listener.updated();
            }
        });
    }

    private void estimateBackgroundColors() {
        this.activeBackgroundColor = this.estimateBackgroundColor(true);
        this.inactiveBackgroundColor = this.estimateBackgroundColor(false);
        double d = 255 / this.fadeSelectedColors.length;
        for (int i = 0; i < this.fadeSelectedColors.length; ++i) {
            if (this.activeBackgroundColor != null) {
                this.fadeSelectedColors[i] = new Color(this.activeBackgroundColor.getRed(), this.activeBackgroundColor.getGreen(), this.activeBackgroundColor.getBlue(), (int)((double)(i + 1) * d));
            }
            if (this.inactiveBackgroundColor == null) continue;
            this.fadeNormalColors[i] = new Color(this.inactiveBackgroundColor.getRed(), this.inactiveBackgroundColor.getGreen(), this.inactiveBackgroundColor.getBlue(), (int)((double)(i + 1) * d));
        }
    }

    private Color estimateBackgroundColor(boolean bl) {
        this.setSize(400);
        this.iFrame.setSelectedActivated(bl);
        BufferedImage bufferedImage = new BufferedImage(this.iFrame.getWidth(), this.iFrame.getHeight(), 2);
        int n = this.iFrame.getWidth() - this.iFrameInsets.right - 3;
        int n2 = this.iFrameInsets.top + 3;
        final int n3 = n;
        final int n4 = n2;
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            public int filterRGB(int n, int n2, int n32) {
                if (n3 == n && n4 == n2) {
                    int n42 = n32 >> 16 & 0xFF;
                    int n5 = n32 >> 8 & 0xFF;
                    int n6 = n32 & 0xFF;
                    int n7 = n32 >> 24 & 0xFF;
                    TitleBarUI.this.foundBackgroundColor = new Color(n42, n5, n6, n7);
                }
                return n32;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        this.iFrame.paint(bufferedImage.getGraphics());
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        bufferedImage2.getGraphics().drawImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource), 0, 0, null);
        return this.foundBackgroundColor;
    }

    public DimensionProvider getSizeDimensionProvider() {
        return this.skipIFrame ? null : new DimensionProvider(){

            public Dimension getDimension(Component component) {
                return TitleBarUI.this.minimumSize;
            }
        };
    }

    public void paintTitleBar(Component component, Graphics graphics, boolean bl, int n, int n2, Direction direction) {
        if (this.enabled) {
            View view = this.findView(component);
            if (view == null) {
                return;
            }
            this.setTitleAndIcon(view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getTitle(), view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getIcon());
            this.iFrame.setSelectedActivated(bl);
            this.setSize(n);
            Shape shape = graphics.getClip();
            graphics.clipRect(0, 0, n, this.reportedMinimumSize.height - this.iFrameInsets.top - this.iFrameInsets.bottom);
            graphics.translate(-this.iFrameInsets.left, -this.iFrameInsets.top);
            this.iFrame.paint(graphics);
            graphics.translate(this.iFrameInsets.left, this.iFrameInsets.top);
            graphics.setClip(shape);
            this.paintSolidButtonBackground(component, graphics, bl);
        }
    }

    private void paintSolidButtonBackground(Component component, Graphics graphics, boolean bl) {
        ViewTitleBar viewTitleBar = (ViewTitleBar)component;
        JComponent[] jComponentArray = viewTitleBar.getRightTitleComponents();
        if (jComponentArray.length > 0) {
            int n = 0;
            for (int i = 0; i < jComponentArray.length; ++i) {
                if (!jComponentArray[i].isVisible()) continue;
                n += jComponentArray[i].getWidth();
            }
            Color color = bl ? this.activeBackgroundColor : this.inactiveBackgroundColor;
            Color[] colorArray = bl ? this.fadeSelectedColors : this.fadeNormalColors;
            for (int i = 0; i < colorArray.length; ++i) {
                graphics.setColor(colorArray[i]);
                int n2 = component.getWidth() - n - (colorArray.length - i) - 4;
                graphics.drawLine(n2, 2, n2, component.getHeight() - 4);
            }
            graphics.setColor(color);
            graphics.fillRect(component.getWidth() - n - 4, 2, n + 4, component.getHeight() - 4);
        }
    }

    private void setTitleAndIcon(String string, Icon icon) {
        this.iFrame.setTitle(string);
        this.iFrame.setFrameIcon(icon == null ? SizeIcon.EMPTY : icon);
    }

    private View findView(Component component) {
        if (component == null || component instanceof View) {
            return (View)component;
        }
        return this.findView(component.getParent());
    }

    private void setSize(int n) {
        this.iFrame.setSize(n + this.iFrameInsets.left + this.iFrameInsets.right, this.reportedMinimumSize.height);
        this.iFrame.invalidate();
        this.iFrame.validate();
    }

    public boolean isRenderingIcon() {
        return !this.skipIFrame;
    }

    public boolean isRenderingTitle() {
        return !this.skipIFrame;
    }

    public Direction getRenderingDirection() {
        return Direction.RIGHT;
    }

    public ComponentPainter getInactiveComponentPainter() {
        if (!this.skipIFrame) {
            return this.inactiveComponentPainter;
        }
        Color color = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        if (color == null) {
            color = this.inactiveBackgroundColor;
        }
        return this.createComponentPainter(color, UIManager.getColor("InternalFrame.inactiveTitleGradient"));
    }

    public ComponentPainter getActiveComponentPainter() {
        if (!this.skipIFrame) {
            return this.activeComponentPainter;
        }
        Color color = UIManager.getColor("InternalFrame.activeTitleBackground");
        if (color == null) {
            color = this.activeBackgroundColor;
        }
        return this.createComponentPainter(color, UIManager.getColor("InternalFrame.activeTitleGradient"));
    }

    public Insets getInsets() {
        return this.skipIFrame ? new Insets(2, 2, 2, 2) : new Insets(0, 0, 0, 4);
    }

    public Color getInactiveBackgroundColor() {
        return this.inactiveBackgroundColor;
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    private ComponentPainter createComponentPainter(final Color color, final Color color2) {
        final Color color3 = ColorUtil.blend(color, color2, 0.5);
        final ComponentPainter componentPainter = this.createGradientSegmentPainter(color, color2, true);
        return new ComponentPainter(){

            public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            }

            public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.setColor(color3);
                graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
                componentPainter.paint(component, graphics, n + 2, n2 + 2, n3 - 4, n4 - 4, direction, bl, bl2);
                graphics.setColor(color);
                graphics.drawLine(n + 1, n4 - 1 + n2, n + n3 - 1, n4 - 1 + n2);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }

            public boolean isOpaque(Component component) {
                return componentPainter.isOpaque(component);
            }

            public Color getColor(Component component) {
                return componentPainter.getColor(component);
            }
        };
    }

    private ComponentPainter createGradientSegmentPainter(Color color, Color color2, boolean bl) {
        if (color != null) {
            color2 = color2 == null ? color : color2;
            color = ColorUtil.mult(color, bl ? 1.05 : 0.9);
            color2 = ColorUtil.mult(color2, bl ? 0.9 : 1.05);
            return new GradientComponentPainter(color, color, color2, color2);
        }
        return null;
    }

    private class IFrame
    extends JInternalFrame {
        public void updateUI() {
            super.updateUI();
            this.setClosable(false);
            this.setIconifiable(false);
            this.setMaximizable(false);
            this.setFocusable(false);
        }

        public void setSelectedActivated(boolean bl) {
            try {
                this.setSelected(bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }

        public boolean isShowing() {
            return true;
        }
    }
}

