% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cophen.vector.R
\name{cophen.vector}
\alias{cophen.vector}
\title{Computes the cophenetic vector of a phylogenetic tree}
\usage{
cophen.vector(tree, set.of.labels = NULL)
}
\arguments{
\item{tree}{a single phylogenetic tree. It can be entered as a string the Newick format, as a 'phylo' object (\code{ape} package) or as an 'igraph' object (\code{igraph} package).}

\item{set.of.labels}{a list containing the set of labels of the tree (in the order of appearance from its newicks form). By default is \code{NULL} due to if \code{tree} is a \code{phylo} object or a newick string it is no necessary to specify it.}
}
\value{
A numeric array.
}
\description{
Given a phylogenetic tree, computes the cophenetic vector of that phylogenetic tree.
}
\details{
The cophenetic vector is formed by all the cophenetic values between each pair of leaves. The cophenetic value of two different leaves i and j is the depth of the lowest common ancestor of the nodes in the tree labeled with i and j. If i=j, then the cophenetic value is the depth of that leaf.
}
\examples{
# Computation of the cophenetic vector of trees 
# entered in newick format:
cophen.vector("(1,2,3,4,5);")
cophen.vector("(1,(2,(3,(4,5))));")

# Computation of the cophenetic vector of trees 
# entered as a phylo object:
require(ape)
random.tree = rtree(5,rooted=TRUE)
cophen.vector(random.tree) 

}
\references{
A. Mir, F. Rossello, L.Rotger, A new balance index for phylogenetic trees. \emph{Mathematical Biosciences} \bold{241} (2013), 125-136.

G. Cardona, A. Mir, F. Rossello, L. Rotger, D. Sanchez, Cophenetic metrics for phylogenetic trees, after Sokal and Rohlf. \emph{BMC Bioinformatics} \bold{14} (2013), 3.
}
\author{
Lucia Rotger
}
