% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortTiming.R
\name{summariseCohortTiming}
\alias{summariseCohortTiming}
\title{Summarise timing between entries into cohorts in a cohort table}
\usage{
summariseCohortTiming(
  cohort,
  cohortId = NULL,
  strata = list(),
  restrictToFirstEntry = TRUE,
  estimates = c("min", "q25", "median", "q75", "max"),
  density = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{restrictToFirstEntry}{If TRUE only an individual's first entry per
cohort will be considered. If FALSE all entries per individual will be
considered.}

\item{estimates}{Summary statistics to use when summarising timing.}

\item{density}{TRUE or FALSE. If TRUE, estimates for a density plot will
also be computed.}
}
\value{
A summary of timing between entries into cohorts in the cohort table.
}
\description{
Summarise timing between entries into cohorts in a cohort table
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- CohortCharacteristics::mockCohortCharacteristics()
summariseCohortTiming(cdm$cohort2) |> dplyr::glimpse()
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
