% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReindexCohortsByDays.R
\name{reindexCohortsByDays}
\alias{reindexCohortsByDays}
\title{Reindex cohort(s) by relative days}
\usage{
reindexCohortsByDays(
  connectionDetails = NULL,
  connection = NULL,
  sourceCohortDatabaseSchema = NULL,
  sourceCohortTable = "cohort",
  sourceCohortIds,
  targetCohortDatabaseSchema = NULL,
  targetCohortTable,
  offsetStartAnchor = "cohort_start_date",
  offsetEndAnchor = "cohort_end_date",
  reindexRules,
  cdmDatabaseSchema = NULL,
  purgeConflicts = FALSE,
  isTempTable = FALSE,
  bulkLoad = Sys.getenv("DATABASE_CONNECTOR_BULK_UPLOAD"),
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{sourceCohortDatabaseSchema}{Schema name where your source cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{sourceCohortTable}{The name of the source cohort table.}

\item{sourceCohortIds}{An array of one or more cohortIds in the source cohort table.}

\item{targetCohortDatabaseSchema}{Schema name where your target cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetCohortTable}{The name of the target cohort table.}

\item{offsetStartAnchor}{Determines the anchor point for the start of the reindexing. It can be either
cohort_start_date or cohort_end_date of sourceCohort.}

\item{offsetEndAnchor}{Determines the anchor point for the end of the reindexing. It can be either
cohort_start_date or cohort_end_date of targetCohort.}

\item{reindexRules}{A data frame specifying the reindexing rules. It should contain the following columns: 'offsetId'
a unique key for identifying the newly generated cohorts. Each offsetId corresponds to a
specific reindex rule and will be used to create new cohort id in targetCohort. 'offsetStartValue'
is an integer value indicating the number of days to 'offsetStartAnchor'. A positive
values will extend, while negative values will shorten the start date from
the 'offsetStartAnchor'. offsetEndValue' An integer value indicating the number of
days to offset the end date. Positive values will extend, while negative values will
shorten the end date from the 'offsetEndAnchor'.}

\item{cdmDatabaseSchema}{Schema name where your patient-level data in OMOP CDM format resides.
Note that for SQL Server, this should include both the database and
schema name, for example 'cdm_data.dbo'.}

\item{purgeConflicts}{If there are conflicts in the target cohort table i.e. the target cohort table
already has records with newCohortId, do you want to purge and replace them
with transformed. By default - it will not be replaced, and an error message is thrown.}

\item{isTempTable}{Is the output a temp table. If yes, a new temp table is created. This will required
an active connection. Any old temp table is dropped and replaced.}

\item{bulkLoad}{See 'insertTable' function in 'DatabaseConnector'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
If output is temp table, then the name of the temp table is returned.
}
\description{
reindexCohort changes the cohort_start_date and/or cohort_end_date of
one or more source cohorts based on a set of reindexing rules. The output
is a one or more valid target cohorts.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
