% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCodeUse.R
\name{summariseCohortCodeUse}
\alias{summariseCohortCodeUse}
\title{Summarise code use among a cohort in the cdm reference}
\usage{
summariseCohortCodeUse(
  x,
  cdm,
  cohortTable,
  cohortId = NULL,
  timing = "any",
  countBy = c("record", "person"),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL
)
}
\arguments{
\item{x}{Vector of concept IDs}

\item{cdm}{cdm_reference via CDMConnector::cdmFromCon()}

\item{cohortTable}{A cohort table from the cdm reference.}

\item{cohortId}{A vector of cohort IDs to include}

\item{timing}{When to assess the code use relative cohort dates. This can
be "any"(code use any time by individuals in the cohort) or  "entry" (code
use on individuals' cohort start date).}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}
}
\value{
A tibble with results overall and, if specified, by strata
}
\description{
Summarise code use among a cohort in the cdm reference
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomiaDir())
cdm <- CDMConnector::cdmFromCon(con,
                                  cdmSchema = "main",
                                  writeSchema = "main")
cdm <- CDMConnector::generateConceptCohortSet(cdm = cdm,
conceptSet = list(a = 260139,
                  b = 1127433),
                  name = "cohorts",
                  end = "observation_period_end_date",
                  overwrite = TRUE)

results_cohort_mult <-
summariseCohortCodeUse(list(cs = c(260139,19133873)),
                      cdm = cdm,
                      cohortTable = "cohorts",
                      timing = "entry")

results_cohort_mult
CDMConnector::cdmDisconnect(cdm)
}
}
