% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaStdParams.R
\name{ctmaStdParams}
\alias{ctmaStdParams}
\title{ctmaStdParams}
\usage{
ctmaStdParams(
  fit = NULL,
  times = 1,
  digits = 4,
  standardize = TRUE,
  oneTailed = FALSE
)
}
\arguments{
\item{fit}{CoTiMA or ctsem fit object with or without random intercepts}

\item{times}{scalar (1 by defualt) or vector of scalars defining the discrete time lags for which standardized drift effects are computed.}

\item{digits}{rounding (4 by default)}

\item{standardize}{logical. TRUE (default) or FALSE (does not standardize and just computes discrete time effects)}

\item{oneTailed}{logical. FALSE (default) or TRUE. If TRUE, one-tailed CIs will be reported}
}
\value{
ctmaStdParams returns a list of standardized discrete time drift matrices for different time intervals.
}
\description{
Computes standardized drift effects from a CoTiMA or ctsem fit object. Can only handle CLPM or RI-CLPM fit objects.
}
\examples{
\dontrun{
ctmaStdParams(CoTiMAFullFit_3_orig, times=c(.1, 1, 2), digits=6, standardize=TRUE)
}


}
