% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotacti.R
\name{plot.acti}
\alias{plot.acti}
\title{AutoCorrelation Transformation Function visualisation}
\usage{
\method{plot}{acti}(x, ...)
}
\arguments{
\item{x}{fitactf result object}

\item{...}{other arguments}
}
\description{
Visualizes the autocorrelation tranformation integral
(there are two possible methods for plotting - base graphics and ggplot2 package)
}
\examples{

library(CoSMoS)

## choose the marginal distribution as Pareto type II with corresponding parameters
dist <- 'paretoII'
distarg <- list(scale = 1, shape = .3)

## estimate rho 'x' and 'z' points using ACTI
p <- actpnts(margdist = dist, margarg = distarg, p0 = 0)

## fit ACTF
fit <- fitactf(p)

## plot the results
plot(fit)
plot(fit, main = 'Pareto type II distribution \nautocorrelation tranformation')

}
