% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkmodel}
\alias{checkmodel}
\title{Check model function}
\usage{
checkmodel(margdist, margarg, n, p = NULL, p0 = 0.6, acsvalue,
  TSn = 1, distbounds = c(-Inf, Inf), plot = FALSE,
  returnTS = FALSE)
}
\arguments{
\item{margdist}{target marginal distribution}

\item{margarg}{list of marginal distribution arguments}

\item{n}{number of values}

\item{p}{integer - model order (if NULL - limits maximum model order according to auto-correlation structure values)}

\item{p0}{probability zero}

\item{acsvalue}{target auto-correlation structure (from lag 0)}

\item{TSn}{number of timeseries to be generated}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}

\item{plot}{logical - plot the result? (if TRUE, saved as an attribute 'plot')}

\item{returnTS}{logical - return timeseries generated by the check function? (if TRUE, saved as an attribute 'TS')}
}
\description{
Generates a synthetic time series with the given properties and compares its sample statistics with the theoretically expected values.
}
\examples{

library(CoSMoS)

\donttest{
## check your model
checkmodel(margdist = 'ggamma',
           margarg = list(shape1 = 3,
                          shape2 = .5,
                          scale = 10),
           n = 100000,
           p = 30,
           p0 = 0,
           acsvalue = acs(id = 'weibull',
                          t = 0:30,
                          shape = .5,
                          scale = 10))
}

\dontshow{
checkmodel(margdist = 'ggamma',
           margarg = list(shape1 = 3,
                          shape2 = .5,
                          scale = 10),
           n = 1000,
           p = 30,
           p0 = 0,
           acsvalue = acs(id = 'weibull',
                          t = 0:30,
                          shape = .5,
                          scale = 10))
}

}
\keyword{internal}
