% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVElatCont.R
\name{plotVElatCont}
\alias{plotVElatCont}
\title{Plotting Treatment (Vaccine) Efficacy Curves for Different Correlate of Risk Relative Risks for Continuous Biomarkers}
\usage{
plotVElatCont(outComputePower, outDir = NULL)
}
\arguments{
\item{outComputePower}{a list of lists of length \code{1} containing output from \code{\link{computePower}} or a character string specifying the \code{.RData} file containing \code{\link{computePower}} output}

\item{outDir}{a character string specifying path to output \code{.RData} file, necessary if \cr\code{outComputePower} is a character string. Default is \code{NULL}.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots the treatment (vaccine) efficacy curve for the true latent biomarker for eight different values of the latent correlate of risk
relative risk and the lowest vaccine efficacy level for the true biomarker. All curves assume \code{rho=1}, and treatment (vaccine)
efficacy ranges from 0 to 1. The legend is completely determined by the function.
}
\details{
\code{\link{computePower}} function input parameter \code{VElowest} must have length greater than or equal to eight
for all eight scenarios to have unique RRc and VElowest. Otherwise, only \code{length(VElowest)} unique
VE curves will be displayed.

When interpreting the output of the function, the null hypothesis corresponds to a flat curve where vaccine efficacy for all values of the
true latent biomarker is equal to the overall vaccine efficacy. Increasing departures from the null hypothesis correspond
to increasingly variable and steep VE curves. The output assumes the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}
is constant for all values of the latent and observed biomarker and that there is no measurement error (\eqn{\rho=1}). When this is the case,
an association of the biomarker with infection risk in the vaccine group (a correlate of risk) is equivalent to an association of the biomarker
with treatment (vaccine) efficacy.

The function's plot can also be interpreted in conjunction with the output of the \code{\link{plotPowerCont}} function by
matching the CoR relative risk in the two plots and examining power compared to VE. This sheds light on the importance
of overall VE on power and further enables correlates of risk results to be interpreted in terms of
potential correlates of efficacy/protection.
}
\examples{
# Example scenario with continuous biomarker, where values of rho are varied

# Set input parameters for computePower function
nCasesTx <- 10
nControlsTx <- 300
nCasesTxWithS <- 10
controlCaseRatio <- 3
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=8)
Plat0 <- P0 <- 0.2
Plat2 <- P2 <- 0.6
M <- 13
alpha <- 0.05
sigma2obs <- 1
rho <- 1
biomType <- "continuous"

# Output from computePower function is stored in an object as a list
pwr <- computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
                    controlCaseRatio=controlCaseRatio, risk0=risk0, VEoverall=VEoverall,
                    PlatVElowest=PlatVElowest, VElowest=VElowest, Plat0=Plat0, Plat2=Plat2,
                    P0=P0, P2=P2, M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho, biomType=biomType)

# Set parameters for plotPowerCont function
# outComputePower is a list containing output from the computePower function
outComputePower <- pwr
plotVElatCont(outComputePower=outComputePower)

\dontrun{
# Output from computePower function is saved in an RData file
computePower(..., saveDir = "myDir", saveFile = "myFile.RData")
# outComputePower is a character string specifying the file containing the computePower output
# outDir is a character string specifying the outComputePower file directory
outComputePower <- "myFile.RData"
outDir <- "~/myDir"
plotVElatCont(outComputePower, outDir=outDir)
}

}
\seealso{
\code{\link{computePower}}, \code{\link{plotPowerCont}}
}
