% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePower.R
\name{computePower}
\alias{computePower}
\title{Power Calculations for Assessing Intermediate Biomarkers as Correlates of Risk in the Active Treatment Group in Clinical Efficacy Trials, Accounting for Biomarker's Measurement Error and Treatment Efficacy}
\usage{
computePower(nCasesTx, nControlsTx, nCasesTxWithS,
  controlCaseRatio = NULL, VEoverall, risk0, VElat0 = seq(0, VEoverall,
  len = 20), VElat1 = rep(VEoverall, 20), VElowest = NULL,
  Plat0 = NULL, Plat2 = NULL, P0 = Plat0, P2 = Plat2,
  PlatVElowest = NULL, sens = NULL, spec = NULL, FP0 = NULL,
  FN2 = NULL, M = 100, alpha = 0.05, sigma2obs = 1, rho = 1,
  biomType = c("continuous", "trichotomous", "dichotomous"),
  cohort = FALSE, p = NULL, tpsMethod = c("PL", "ML", "WL"),
  saveDir = NULL, saveFile = "CoRpower.RData", saveDataDir = NULL,
  saveDataFile = "fullData.RData", corr = NULL, nCasesPla = NULL,
  nControlsPla = NULL, sensBIP = NULL, specBIP = NULL,
  FP0BIP = NULL, FN2BIP = NULL, P0BIP = P0, P2BIP = P2)
}
\arguments{
\item{nCasesTx}{an integer vector specifying the observed (for a finished trial) or expected (for a trial in design stage) number of clinical endpoint cases between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group. Each value represents a distinct scenario for power assessment.}

\item{nControlsTx}{an integer vector specifying the observed (for a finished trial) or expected (for a trial in design stage) number of controls with completed follow-up through \eqn{\tau_{max}} and endpoint-free at \eqn{\tau_{max}} in the active treatment group. Each value represents a distinct scenario for power assessment. The ordering in \code{nCasesTx} and \code{nControlsTx} must match.}

\item{nCasesTxWithS}{an integer vector specifying the observed (for a finished trial) or expected (for a trial in design stage) number of clinical endpoint cases between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response. Each value represents a distinct scenario for power assessment. The ordering must match \code{nCasesTx} and \code{nControlsTx}.}

\item{controlCaseRatio}{an integer vector specifying the number of closeout controls sampled per case for biomarker measurement in the without replacement case-control sampling design (set to \code{NULL} by default). Each value represents a distinct scenario for power assessment.}

\item{VEoverall}{a numeric value specifying the true overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}}

\item{risk0}{a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}}

\item{VElat0}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lower protected subgroup for a dichotomous or trichotomous biomarker. Each value of \code{VElat0} corresponds to one unique effect size (\eqn{RR_t}). Default ranges from \code{VEoverall} (\eqn{H_0}) to 0 (maximal \eqn{H_1} not allowing harm by treatment).}

\item{VElat1}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent medium protected subgroup for a trichotomous biomarker. Each value corresponds to one unique effect size (\eqn{RR_t}). The ordering must match \code{VElat0}. Set to \code{VEoverall} by default.}

\item{VElowest}{a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup for a continuous biomarker. Default ranges from \code{VEoverall} (\eqn{H_0}) to 0 (maximal \eqn{H_1} not allowing harm by treatment).}

\item{Plat0}{a numeric vector specifying the prevalence of the latent lower protected subgroup for a dichotomous or trichotomous biomarker (set to \code{NULL} by default). Each value represents a distinct scenario for power assessment. The ordering in \code{Plat0}, \code{Plat2}, \code{P0}, and \code{P2} must match.}

\item{Plat2}{a numeric vector specifying the prevalence of the latent higher protected subgroup for a dichotomous or trichotomous biomarker (set to \code{NULL} by default). Each value represents a distinct scenario for power assessment. The ordering in \code{Plat0}, \code{Plat2}, \code{P0}, and \code{P2} must match.}

\item{P0}{a numeric vector specifying the probability of low biomarker response for a dichotomous or trichotomous biomarker (set to \code{Plat0} by default). Each value represents a distinct scenario for power assessment. The ordering in \code{Plat0}, \code{Plat2}, \code{P0}, and \code{P2} must match.}

\item{P2}{a numeric vector specifying the probability of high biomarker response for a dichotomous or trichotomous biomarker (set to \code{Plat2} by default). Each value represents a distinct scenario for power assessment. The ordering in \code{Plat0}, \code{Plat2}, \code{P0}, and \code{P2} must match.}

\item{PlatVElowest}{a numeric vector specifying the prevalence of the latent lowest-efficacy subgroup for a continuous biomarker (set to \code{NULL} by default). Each value represents a distinct scenario for power assessment.}

\item{sens}{a numeric vector specifying the sensitivity, i.e., the probability of high biomarker response conditional on membership in the higher protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'. Each value represents a distinct scenario for power assessment. The ordering in \code{sens}, \code{spec}, \code{FP0}, and \code{FN2} must match.}

\item{spec}{a numeric vector specifying the specificity, i.e., the probability of low biomarker response conditional on membership in the lower protected subgroup, of a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'. Each value represents a distinct scenario for power assessment. The ordering in \code{sens}, \code{spec}, \code{FP0}, and \code{FN2} must match.}

\item{FP0}{a numeric vector specifying the false positive rate, i.e., the probability of high biomarker response conditional on membership in the lower protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'. Each value represents a distinct scenario for power assessment. The ordering in \code{sens}, \code{spec}, \code{FP0}, and \code{FN2} must match.}

\item{FN2}{a numeric vector specifying the false negative rate, i.e., the probability of low biomarker response conditional on membership in the higher protected subgroup, for a dichotomous or trichotomous biomarker. Default is \code{NULL}, which indicates the use of 'approach 2'. Each value represents a distinct scenario for power assessment. The ordering in \code{sens}, \code{spec}, \code{FP0}, and \code{FN2} must match.}

\item{M}{an integer value specifying the number of simulated clinical trials. Default is \code{100}.}

\item{alpha}{a numeric value specifying the two-sided Wald test type-I error rate. Default is \code{0.05}.}

\item{sigma2obs}{a numeric value specifying the variance of the observed continuous biomarker or of the dichotomous or trichotomous biomarker simulated using 'approach 2' (set to \code{1} by default).}

\item{rho}{a numeric vector specifying distinct protection-relevant fractions of \code{sigma2obs}. Each value represents a distinct scenario for power assessment.}

\item{biomType}{a character string specifying the biomarker type. Default is \code{continuous}; other choices are \code{dichotomous} and \code{trichotomous}.}

\item{cohort}{a logical value for whether a case-cohort Bernoulli sampling design is to be used. If \code{FALSE} (default), the case-control without replacement sampling is used.}

\item{p}{a numeric vector specifying the probability of sampling into the subcohort in the case-cohort design (\code{NULL} by default). Each value represents a distinct scenario for power assessment.}

\item{tpsMethod}{a character string specifying the estimation method in the inverse probability weighted logistic regression model fit by the \code{tps} function in the \code{osDesign} package. The options are \code{PL} for pseudo-likelihood (default), \code{ML} for maximum likelihood, and \code{WL} for weighted likelihood.}

\item{saveDir}{a character string specifying the path for a directory in which the output of the power calculation is to be saved. If \code{NULL} (default), the output is returned only.}

\item{saveFile}{a character vector specifying the name(s) of the \code{.RData} file(s) storing the output of the power calculation, used only if \code{saveDir} is not \code{NULL}. All file names must include ".RData" at the end. Default is \code{CoRpower.RData}.}

\item{saveDataDir}{a character string specifying the path for a directory in which the simulated data, including placebo group and baseline immunogenicity predictor (BIP) data, are to be saved. If \code{NULL} (default), the simulated data are not saved.}

\item{saveDataFile}{a character vector specifying the name(s) of the \code{.RData} file(s) in which the simulated data, including placebo group and BIP data, are to be saved; used only if \code{saveDataDir} is not \code{NULL}. All file names must include ".RData" at the end. Default is \code{fullData.RData}.}

\item{corr}{a numeric vector in \eqn{[-1,1]} specifying the correlation between a continuous baseline immunogenicity predictor (BIP) and the (underlying) continuous intermediate biomarker response (\code{NULL} by default). Each value represents a distinct scenario for power assessment. A useful BIP is highly correlated with the biomarker response at \eqn{\tau}. It must be provided if \code{saveDataDir} is specified and a trichotomous biomarker under 'approach 2' or a continuous biomarker is considered.}

\item{nCasesPla}{an integer vector specifying the observed (for a finished trial) or expected (for a trial in design stage) number of clinical endpoint cases between \eqn{\tau} and \eqn{\tau_{max}} in the placebo group. Each value represents a distinct scenario matching \code{nCasesTx}. Default is \code{NULL}. It must be provided if \code{saveDataDir} is specified.}

\item{nControlsPla}{an integer vector specifying the observed (for a finished trial) or expected (for a trial in design stage) number of controls with completed follow-up through \eqn{\tau_{max}} and endpoint-free at \eqn{\tau_{max}} in the placebo group. Each value represents a distinct scenario matching \code{nControlsTx}. Default is \code{NULL}. It must be provided if \code{saveDataDir} is specified.}

\item{sensBIP}{a numeric vector specifying "the sensitivity" of a dichotomous or trichotomous BIP, i.e., the probability of a high value of the BIP conditional on high biomarker response. Default is \code{NULL}, which indicates the use of 'approach 2'. It must be provided if \code{saveDataDir} is specified and 'approach 1' is to be used. Each value results in generating a separate BIP variable in the output data.}

\item{specBIP}{a numeric vector specifying "the specificity" of a dichotomous or trichotomous BIP, i.e., the probability of a low value of the BIP conditional on low biomarker response. Default is \code{NULL}, which indicates the use of 'approach 2'. It must be provided if \code{saveDataDir} is specified and 'approach 1' is to be used. Each value results in generating a separate BIP variable in the output data.}

\item{FP0BIP}{a numeric vector specifying "the false positive rate" of a dichotomous or trichotomous BIP, i.e., the probability of a high value of the BIP conditional on low biomarker response. Default is \code{NULL}, which indicates the use of 'approach 2'. It must be provided if \code{saveDataDir} is specified and 'approach 1' is to be used. Each value results in generating a separate BIP variable in the output data.}

\item{FN2BIP}{a numeric vector specifying "the false negative rate" of a dichotomous or trichotomous BIP, i.e., the probability of a low value of the BIP conditional on high biomarker response. Default is \code{NULL}, which indicates the use of 'approach 2'. It must be provided if \code{saveDataDir} is specified and 'approach 1' is to be used. Each value results in generating a separate BIP variable in the output data.}

\item{P0BIP}{a numeric vector specifying the probability of a low value of a dichotomous or trichotomous BIP. If unspecified, it is set to \code{P0}. Each value results in generating a separate BIP variable in the output data.}

\item{P2BIP}{a numeric vector specifying the probability of a high value of a dichotomous or trichotomous BIP. If unspecified, it is set to \code{P2}. Each value results in generating a separate BIP variable in the output data.}
}
\value{
If \code{saveDir} is specified, an output list (named \code{pwr}) for each power scenario is saved as an \code{.RData} file. Otherwise, the function returns a list of lists,
where the outer list ranges over specified values of the varying argument(s) whose components denote distinct scenarios, and the inner list is the output list for each power scenario.
For a dichotomous or trichotomous biomarker, each output list has the following components:
\itemize{
  \item \code{power}: a numeric vector of fractions of simulated trials in which the null hypothesis \eqn{H_0} is rejected. Each value of the vector corresponds to a value in the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{RRt}: a numeric vector of correlate-of-risk relative-risk effect sizes. Each value of the vector corresponds to a value in the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{risk1_2}: a numeric vector of conditional endpoint risks given a high biomarker response in the active treatment group. Each value of the vector corresponds to a value in the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{risk1_0}: a numeric vector of conditional endpoint risks given a low biomarker response in the active treatment group. Each value of the vector corresponds to a value in the grid of treatment (vaccine) efficacies specified by \code{VElat0} and \code{VElat1}.
  \item \code{VElat2}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent higher protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{VElat0}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lower protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{Plat2}: a numeric value specifying the prevalence of the latent higher protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{Plat0}: a numeric value specifying the prevalence of the latent lower protected subgroup for a dichotomous or trichotomous biomarker
  \item \code{P2}: a numeric value specifying the probability of high biomarker response for a dichotomous or trichotomous biomarker
  \item \code{P0}: a numeric value specifying the probability of low biomarker response for a dichotomous or trichotomous biomarker
  \item \code{alphaLat}: a numeric vector of the log odds of the clinical endpoint in the subgroup of active treatment recipients with the latent \eqn{x^{\ast}=0} (this coefficient estimate applies to a continuous biomarker)
  \item \code{betaLat}: a numeric vector of the log odds ratio of the clinical endpoint comparing two subgroups of active treatment recipients differing in the latent \eqn{x^{\ast}} by 1 (this coefficient estimate applies to a continuous biomarker)
  \item \code{sens}: a numeric vector of sensitivities (i.e., the probability of high biomarker response conditional on membership in the higher protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{spec}: a numeric vector of specificities (i.e., the probability of low biomarker response conditional on membership in the lower protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{FP0}: a numeric vector of false positive rates (i.e., the probability of high biomarker response conditional on membership in the lower protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{FN2}: a numeric vector of false negative rates (i.e., the probability of low biomarker response conditional on membership in the higher protected subgroup) of the observed dichotomous or trichotomous biomarker as a function of \code{rho}
  \item \code{NcompleteTx}: an integer value specifying \code{nCasesTx} + \code{nControlsTx}, i.e., the number, observed or projected, of active treatment recipients at risk at \eqn{\tau} with an observed endpoint or a completed follow-up through \eqn{\tau_{max}}
  \item \code{nCasesTx}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group
  \item \code{nCasesTxWithS}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response
  \item \code{controlCaseRatio}: an integer specifying the number of controls sampled per case for
  biomarker measurement in the without replacement case-control sampling design
  \item \code{VEoverall}: a numeric value specifying the overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{risk0}: a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{alpha}: a numeric value specifying the two-sided Wald test type-I error rate
  \item \code{rho}: a numeric vector specifying distinct protection-relevant fractions of the variance of the observed biomarker
  \item \code{approach}: a number denoting whether Approach 1 or Approach 2 was used (1 if sens, spec, FP0, FN2 were specified in the input; 2 if rho and sigma2obs were specified in the input)
  \item \code{varyingArg}: a character string containing the name(s) and value(s) of the varying argument
}

For a continuous biomarker, each output list has the following components:
\itemize{
  \item \code{power}: a numeric vector of fractions of simulated trials in which the null hypothesis \eqn{H_0} is rejected. Rows represent calculations for different values of \code{rho} or \code{nCasesTx}, depending on which is a vector. Columns represent calculations for the grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup, specified by \code{VElowest}.
  \item \code{RRc}: a numeric vector of correlate-of-risk relative-risk effect sizes as a function of the grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup, specified by \code{VElowest}
  \item \code{betaLat}: a numeric vector specifying the log odds ratio of the clinical endpoint comparing two subgroups of active treatment recipients differing in the latent \eqn{x^{\ast}} by 1 (this coefficient estimate applies to a continuous biomarker)
  \item \code{alphaLat}: a numeric vector specifying the the log odds of the clinical endpoint in the subgroup of active treatment recipients with the latent \eqn{x^{\ast}=0} (this coefficient estimate applies to a continuous biomarker)
  \item \code{PlatVElowest}: a numeric value specifying the prevalence of the latent lowest-efficacy subgroup for a continuous biomarker
  \item \code{VElowest}: a numeric vector specifying a grid of treatment (vaccine) efficacy levels in the latent lowest-efficacy subgroup for a continuous biomarker
  \item \code{sigma2obs}: a numeric value specifying the variance of the observed continuous biomarker or of the dichotomous or trichotomous biomarker simulated using 'approach 2'
  \item \code{NcompleteTx}: an integer value specifying \code{nCasesTx} + \code{nControlsTx}, i.e., the number, observed or projected, of active treatment recipients at risk at \eqn{\tau} with an observed endpoint or a completed follow-up through \eqn{\tau_{max}}
  \item \code{nCasesTx}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group
  \item \code{nCasesTxWithS}: an integer value specifying the number of clinical endpoint cases observed (or projected) between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response
  \item \code{controlCaseRatio}: an integer value specifying the number of controls sampled per case for biomarker measurement in the without replacement case-control sampling design
  \item \code{VEoverall}: a numeric value specifying the overall treatment (vaccine) efficacy between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{risk0}: a numeric value specifying the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}
  \item \code{alpha}: a numeric value specifying the two-sided Wald test type-I error rate
  \item \code{rho}: a numeric vector specifying distinct protection-relevant fractions of the variance of the observed biomarker
  \item \code{varyingArg}: a character string containing the name(s) and value(s) of the varying argument
}

If \code{saveDataDir} is specified, the simulated data, including placebo group and BIP data, are saved in one or more \code{.RData} file(s)
containing a list of lists of data frames.
The components of the outer list consist each of one Monte-Carlo iteration of simulated data for all values of \code{VElat0} or \code{VElat1} if
the biomarker is trichotomous, or of \code{VElowest} if the biomarker is continuous. Each data frame corresponds to one simulated trial.
}
\description{
Performs a power calculation for assessing a univariate dichotomous, trichotomous, or continuous intermediate biomarker response as a correlate of risk
in the active treatment group in a clinical efficacy trial, accounting for the biomarker's measurement error and treatment efficacy. The statistical methods are described in [Gilbert, Janes, and Huang (2016).
"Power/Sample Size Calculations for Assessing Correlates of Risk in Clinical Efficacy Trials."] Simulated data sets, extended to include placebo group and baseline immunogenicity predictor data, can be exported for
harmonized assessment of biomarker-specific treatment efficacy.
}
\details{
A number of calling arguments can be specified as vectors with each component specifying a distinct scenario for power assessment (saved in a separate \code{.RData} file).
These are referred to as "varying arguments."
Some varying arguments occur in a group, where the length and order of all specified vectors in the group must match; others are the only varying argument in their group.
Only arguments belonging to a single group may be varied at a time; if two or more groups contain vector inputs, the function will treat such inputs as an error.
The following are the groups of varying arguments that can be vectorized:
  \itemize{
    \item \code{nCasesTx}, \code{nControlsTx}, and \code{nCasesTxWithS} (together with \code{nCasesPla} and \code{nControlsPla} if simulated data sets are to be saved)
    \item \code{Plat0}, \code{Plat2}, \code{P0}, and \code{P2}
    \item \code{sens}, \code{spec}, \code{FP0}, and \code{FN2}
    \item \code{controlCaseRatio}
    \item \code{rho}
    \item \code{p}
  }

Arguments independent of biomarker type and sampling design: \code{nCasesTx}, \code{nControlsTx}, \code{nCasesTxWithS}, \code{VEoverall}, \code{risk0},
\code{M}, \code{alpha}, \code{tpsMethod}, \code{saveDir}, \code{saveFile}.

Arguments specific to a trichotomous (or dichotomous) biomarker response: \code{VElat0}, \code{VElat1}, \code{Plat0}, \code{Plat2}, \code{P0},
\code{P2}, \code{biomType = "trichotomous"} (or \code{"dichotomous"})
  \itemize{
    \item Arguments for Approach 1: \code{sens}, \code{spec}, \code{FP0}, \code{FN2}
    \item Arguments for Approach 2: \code{sigma2obs}, \code{rho}
  }

Arguments specific to a continuous biomarker response: \code{VElowest}, \code{PlatVElowest}, \code{sigma2obs}, \code{rho}, \code{biomType = "continuous"}

Arguments for a case-control without replacement sampling design: \code{controlCaseRatio}

Arguments for a case-cohort Bernoulli sampling design: \code{cohort = TRUE}, \code{p}

To save output from the power calculations in an \code{.RData} file, \code{saveDir} must be specified. The default file name is \code{CoRpower.RData};
a different file name may be specified by \code{saveFile} as a single character string, to which the value of the varying argument(s) will be appended for descriptive file naming purposes,
or, alternatively, a character vector may be specified with full file names (a single file will be produced for each value of the varying argument(s)).

To link power calculations for detecting a correlate of risk and a correlate of treatment efficacy, simulated data sets used in the power calculations
can be exported with placebo-group data, with a possible extension including BIP data, for harmonized use by methods assessing biomarker-specific treatment efficacy.
The vignette "Algorithms for Simulating Placebo Group and Baseline Immunogenicity Predictor Data" provides more information on the algorithms and underlying assumptions for
simulating placebo-group and BIP data.
The exported data sets include treatment and placebo group data in the form of full rectangular data (i.e., disregarding biomarker sub-sampling), which enables the user to employ any preferred biomarker sub-sampling design.
To generate and export such data, \code{saveDataDir}, \code{nCasesPla}, and \code{nControlsPla} must be specified. \code{nCasesPla} and \code{nControlsPla} must have
the same length and order of components as \code{nCasesTx}, \code{nControlsTx}, and \code{nCasesTxWithS}.

If a BIP is to be included in the simulated data export, additional arguments are necessary.
If the biomarker is trichotomous and Approach 1 is used, \code{sensBIP}, \code{specBIP}, \code{FP0BIP}, \code{FN2BIP}, \code{P0BIP}, and \code{P2BIP} must be specified;
if the biomarker is trichotomous and Approach 2 is used, \code{corr}, \code{P0BIP}, and \code{P2BIP} must be specified; if the biomarker is continuous, \code{corr} must be specified.

Calling arguments pertaining to the simulation of the BIP in the exported data may also be specified as vectors, independently of the above varying arguments defining the power calculation scenarios
for the active treatment group. Each component of these vectors results in the generation of a separate BIP variable, in the same order, in the output data.
Some of these arguments occur in a group, where the length and order of all specified vectors in the group must match; others are the sole argument in their group.
Only arguments belonging to a single group may be varied at a time; if two or more groups contain vector inputs, the function will treat such inputs as an error.
The following are the groups of BIP arguments that can be vectorized:
   \itemize{
    \item \code{sensBIP}, \code{specBIP}, \code{FP0BIP}, \code{FN2BIP}
    \item \code{P0BIP}, \code{P2BIP}
    \item \code{corr}
  }

The default file name for the outputted data sets is \code{fullData.RData}. A different file name may be specified by \code{saveDataFile}
as a single character string, to which the value of the "varying argument" for the power calculations will be appended for descriptive file naming purposes,
or, alternatively, a character vector may be specified with full file names (a single file will be produced for each value of the varying argument(s)).
Note: if the "varying argument" is \code{controlCaseRatio} or \code{p}, only one file will be generated because these arguments do not affect
the simulation of the full data; therefore, \code{saveDataFile} must be a character string in these cases.
}
\examples{

## Trichotomous biomarker, Approach 1, varying sens and spec ##
## Specify sens, spec, FP0, FN2
nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)  # 20 data points for the power curve
VElat1 <- rep(VEoverall, 20)
Plat0 <- 0.2
Plat2 <- 0.6
P0 <- Plat0  # different values of P0 can be set
P2 <- Plat2  # different values of P2 can be set
sens <- spec <- c(1, 0.9, 0.8, 0.7)
FP0 <- FN2 <- rep(0, 4)
M <- 5
alpha <- 0.05
biomType <- "trichotomous"
computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall,
             risk0=risk0, VElat0=VElat0, VElat1=VElat1, Plat0=Plat0,
             Plat2=Plat2, P0=P0, P2=P2, M=M, alpha=alpha, spec=spec,
             FP0=FP0, sens=sens, FN2=FN2, biomType=biomType)

\dontrun{
## Trichotomous biomarker, Approach 2, varying rho ##
## Saving simulated data (including placebo and BIP data)
## Specify rho, sigma2obs, saveDataDir, saveDataFile, corr

nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)
VElat1 <- rep(VEoverall, 20)
Plat0 <- 0.2
Plat2 <- 0.6
P0 <- Plat0
P2 <- Plat2
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "trichotomous"
saveDataDir <- "~/myDir"
saveDataFile <- "myDataFile.RData"
corr <- 0.7
computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             VElat0=VElat0, VElat1=VElat1, Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho, biomType=biomType,
             saveDataDir=saveDataDir, saveDataFile=saveDataFile, corr=corr)


## dichotomous biomarker, Approach 2, varying rho ##
## Plat0 + Plat2 = 1

nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=20)  # 20 data points for the power curve
VElat1 <- rep(0, 20)  # will not be used by function
Plat0 <- 0.25
Plat2 <- 1 - Plat0
P0 <- Plat0
P2 <- Plat2
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "dichotomous"
computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             VElat0=VElat0, VElat1=VElat1, Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho, biomType=biomType)


## Continuous biomarker, varying rho ##

nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "continuous"
computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall, risk0=risk0,
             PlatVElowest=PlatVElowest, VElowest=VElowest, M=M, alpha=alpha,
             sigma2obs=sigma2obs, rho=rho, biomType=biomType)


## Continuous biomarker, case-cohort sampling design, varying p ##
nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- 0.9
biomType <- "continuous"
cohort <- TRUE
p <- c(0.01, 0.02, 0.03)
computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
             VEoverall=VEoverall, risk0=risk0, PlatVElowest=PlatVElowest,
             VElowest=VElowest, M=M, alpha=alpha, sigma2obs=sigma2obs,
             rho=rho, biomType=biomType, cohort=cohort, p=p)

## Continuous biomarker, saving output, varying sample sizes ##

nCasesTx <- 32
nControlsTx <- 1000
nCasesTxWithS <- 32
controlCaseRatio <- 5
VEoverall <- 0.75
risk0 <- 0.034
PlatVElowest <- 0.2
VElowest <- seq(0, VEoverall, len=20)
M <- 5
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.9, 0.7, 0.5)
biomType <- "continuous"
saveDir <- "~/myDir"
saveFile <- "MyFile.RData"
computePower(nCasesTx=nCasesTx, nCasesTxWithS=nCasesTxWithS, nControlsTx=nControlsTx,
             controlCaseRatio=controlCaseRatio, VEoverall=VEoverall,
             risk0=risk0, PlatVElowest=PlatVElowest, VElowest=VElowest,
             M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho,
             biomType=biomType, saveDir=saveDir, saveFile=saveFile)
}

}
\seealso{
\code{\link{computeN}}, \code{\link{plotPowerTri}}, \code{\link{plotPowerCont}}
}
