% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{GMM}
\alias{GMM}
\title{Gaussian Mixture Model clustering}
\usage{
GMM(data, gaussian_comps = 1, dist_mode = "eucl_dist",
  seed_mode = "random_subset", km_iter = 10, em_iter = 5,
  verbose = FALSE, var_floor = 1e-10, seed = 1)
}
\arguments{
\item{data}{matrix or data frame}

\item{gaussian_comps}{the number of gaussian mixture components}

\item{dist_mode}{the distance used during the seeding of initial means and k-means clustering. One of, \emph{eucl_dist}, \emph{maha_dist}.}

\item{seed_mode}{how the initial means are seeded prior to running k-means and/or EM algorithms. One of, \emph{static_subset}, \emph{random_subset}, \emph{static_spread}, \emph{random_spread}.}

\item{km_iter}{the number of iterations of the k-means algorithm}

\item{em_iter}{the number of iterations of the EM algorithm}

\item{verbose}{either TRUE or FALSE; enable or disable printing of progress during the k-means and EM algorithms}

\item{var_floor}{the variance floor (smallest allowed value) for the diagonal covariances}

\item{seed}{integer value for random number generator (RNG)}
}
\value{
a list consisting of the centroids, covariance matrix ( where each row of the matrix represents a diagonal covariance matrix), weights and the log-likelihoods for each gaussian component. In case of Error it returns the error message and the possible causes.
}
\description{
Gaussian Mixture Model clustering
}
\details{
This function is an R implementation of the 'gmm_diag' class of the Armadillo library. The only exception is that user defined parameter settings are not supported, such as seed_mode = 'keep_existing'.
For probabilistic applications, better model parameters are typically learned with dist_mode set to maha_dist.
For vector quantisation applications, model parameters should be learned with dist_mode set to eucl_dist, and the number of EM iterations set to zero.
In general, a sufficient number of k-means and EM iterations is typically about 10.
The number of training samples should be much larger than the number of Gaussians.
Seeding the initial means with static_spread and random_spread can be much more time consuming than with static_subset and random_subset.
The k-means and EM algorithms will run faster on multi-core machines when OpenMP is enabled in your compiler (eg. -fopenmp in GCC)
}
\examples{

data(dietary_survey_IBS)

dat = as.matrix(dietary_survey_IBS[, -ncol(dietary_survey_IBS)])

dat = center_scale(dat)

gmm = GMM(dat, 2, "maha_dist", "random_subset", 10, 10)

}
\references{
http://arma.sourceforge.net/docs.html
}
