% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catatis_jar.R
\name{catatis_jar}
\alias{catatis_jar}
\title{Perform the CATATIS method on Just About Right data.}
\usage{
catatis_jar(Data, nprod, nsub, levelsJAR=3, beta=0.1, Graph=TRUE, Graph_weights=TRUE,
Test_weights=FALSE, nperm=100)
}
\arguments{
\item{Data}{data frame where the first column is the Assessors, the second is the products and all other columns the JAR attributes with numbers (1 to 3 or 1 to 5, see levelsJAR)}

\item{nprod}{integer. Number of products.}

\item{nsub}{integer. Number of subjects.}

\item{levelsJAR}{integer. 3 or 5 levels. If 5, the data will be transformed in 3 levels.}

\item{beta}{numerical. Parameter for agreement between JAR and other answers. Between 0 and 0.5.}

\item{Graph}{logical. Show the graphical representation? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}

\item{Test_weights}{logical. Should the the weights be tested? Default: FALSE}

\item{nperm}{integer. Number of permutation for the weight tests. Default: 100}
}
\value{
a list with:
        \itemize{
         \item S: the S matrix: a matrix with the similarity coefficient among the subjects
         \item compromise: a matrix which is the compromise of the subjects (akin to a weighted average)
         \item weights: the weights associated with the subjects to build the compromise
         \item weights_tests: the weights tests results
         \item lambda:  the first eigenvalue of the S matrix
         \item overall error: the error for the CATATIS criterion
         \item error_by_sub: the error by subject (CATATIS criterion)
         \item error_by_prod: the error by product (CATATIS criterion)
         \item s_with_compromise: the similarity coefficient of each subject with the compromise
         \item homogeneity: homogeneity of the subjects (in percentage)
         \item CA: the results of correspondance analysis performed on the compromise dataset
         \item eigenvalues: the eigenvalues associated to the correspondance analysis
         \item inertia: the percentage of total variance explained by each axis of the CA
         \item scalefactors: the scaling factors of each subject
         \item nb_1: Can be ignored
         \item param: parameters called
         }
}
\description{
CATATIS method adapted to JAR data.
}
\examples{
data(cheese)
res.cat=catatis_jar(Data=cheese, nprod=8, nsub=72, levelsJAR=5)
summary(res.cat)
#plot(res.cat)

}
\references{
Llobell, F., Vigneau, E. & Qannari, E. M. ((September 14, 2022). Multivariate data analysis and clustering of subjects in a Just about right task. Eurosense, Turku, Finland.
}
\seealso{
\code{\link{catatis}}, \code{\link{plot.catatis}}, \code{\link{summary.catatis}}, \code{\link{cluscata_jar}}, \code{\link{preprocess_JAR}}, \code{\link{cluscata_kmeans_jar}}
}
\keyword{JAR}
