% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustatis_FreeSort_kmeans.R
\name{clustatis_FreeSort_kmeans}
\alias{clustatis_FreeSort_kmeans}
\title{Compute the CLUSTATIS partitionning algorithm on free sorting data}
\usage{
clustatis_FreeSort_kmeans(Data, NameSub=NULL, clust, nstart=40, rho=0,Itermax=30,
Graph_groups=TRUE, Graph_weights=FALSE,  print_attempt=FALSE)
}
\arguments{
\item{Data}{data frame or matrix. Corresponds to all variables that contain subjects results. Each column corresponds to a subject and gives the groups to which the products (rows) are assigned}

\item{NameSub}{string vector. Name of each subject. Length must be equal to the number of clumn of the Data. If NULL, the names are S1,...Sm. Default: NULL}

\item{clust}{numerical vector or integer. Initial partition or number of starting partitions if integer. If numerical vector, the numbers must be 1,2,3,...,number of clusters}

\item{nstart}{integer. Number of starting partitions. Default: 40}

\item{rho}{numerical between 0 and 1. Threshold for the noise cluster. Default:0}

\item{Itermax}{numerical. Maximum of iterations by partitionning algorithm. Default: 30}

\item{Graph_groups}{logical. Should each cluster compromise be plotted? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights in each cluster be plotted? Default: FALSE}

\item{print_attempt}{logical. Print the number of remaining attempts in the multi-start case? Default: FALSE}
}
\value{
a list with:
        \itemize{
         \item group: the clustering partition. If rho>0, some subjects could be in the noise cluster ("K+1")
         \item rho: the threshold for the noise cluster
         \item homogeneity: percentage of homogeneity of the subjects in each cluster and the overall homogeneity
         \item rv_with_compromise: RV coefficient of each subject with its cluster compromise
         \item weights: weight associated with each subject in its cluster
         \item comp_RV: RV coefficient between the compromises associated with the various clusters
         \item compromise: the W compromise of each cluster
         \item coord: the coordinates of objects of each cluster
         \item inertia: percentage of total variance explained by each axis for each cluster
         \item rv_all_cluster: the RV coefficient between each subject and each cluster compromise
         \item criterion: the CLUSTATIS criterion error
         \item param: parameters called
         \item type: parameter passed to other functions
         }
}
\description{
Partitionning algorithm for Free Sorting data. Each cluster is associated with a compromise
computed by the STATIS method. Moreover, a noise cluster can be set up.
}
\examples{
data(choc)
res.clu=clustatis_FreeSort_kmeans(choc, clust=2)
plot(res.clu, Graph_groups=FALSE, Graph_weights=TRUE)
summary(res.clu)

}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2018). Analysis and clustering of multiblock datasets by means of the STATIS and CLUSTATIS methods. Application to sensometrics. Food Quality and Preference, in Press.\cr
Llobell, F., Vigneau, E., Qannari, E. M. (2019). Clustering datasets by means of CLUSTATIS with identification of atypical datasets. Application to sensometrics. Food Quality and Preference, 75, 97-104.
}
\seealso{
\code{\link{clustatis_FreeSort}}, \code{\link{preprocess_FreeSort}}, \code{\link{summary.clustatis}}, , \code{\link{plot.clustatis}}
}
\keyword{FreeSorting}
