% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.statis.R
\name{plot.statis}
\alias{plot.statis}
\title{Displays the STATIS graphs}
\usage{
\method{plot}{statis}(x, axes=c(1,2), Graph_obj=TRUE,
Graph_weights=TRUE, tit="STATIS", col=NULL, cex=1, ...)
}
\arguments{
\item{x}{object of class 'statis'}

\item{axes}{numerical vector (length 2). Axes to be plotted. Default: c(1,2)}

\item{Graph_obj}{logical. Should the compromise graphical representation be plotted? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}

\item{tit}{string. Title for the objects graphical representation. Default: 'STATIS'}

\item{col}{vector. Color for each object. If NULL, col=rainbow(nrow(Data)). Default: NULL}

\item{cex}{numerical. Numeric character expansion factor; multiplied by par("cex") yields the final character size. NULL and NA are equivalent to 1.0.}

\item{...}{further arguments passed to or from other methods}
}
\value{
the STATIS graphs
}
\description{
This function plots the STATIS map and STATIS weights
}
\examples{

 data(smoo)
 NameBlocks=paste0("S",1:24)
 st=statis(Data=smoo,Blocks=rep(2,24),NameBlocks = NameBlocks)
 plot(st, axes=c(1,3), Graph_weights=FALSE)

}
\seealso{
\code{\link{statis}}
}
\keyword{quantitative}
