% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_sim_matrix}
\alias{element_sim_matrix}
\title{Pairwise Comparison of Clusterings}
\usage{
element_sim_matrix(clustering_list, output_type = "matrix")
}
\arguments{
\item{clustering_list}{A list of Clustering objects to be compared with
element-centric similarity.}

\item{output_type}{A string specifying whether the output should be a
matrix or a data.frame.}
}
\value{
A matrix or data.frame containing the pairwise ECS values.
}
\description{
Compare a set of clusterings by calculating their pairwise
average element-centric clustering similarities.
}
\examples{
clustering.list = list()
for (i in 1:20){
  km.res = kmeans(mtcars, 3)$cluster
  clustering.list[[i]] = create_clustering(km.res)
}
element_sim_matrix(clustering.list, output_type='matrix')
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
