% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_frustration}
\alias{element_frustration}
\title{Element-Wise Frustration Between a Set of Clusterings}
\usage{
element_frustration(clustering_list)
}
\arguments{
\item{clustering_list}{A list of Clustering objects used to calculate
the element-wise frustration.}
}
\value{
a vector containing the element-wise frustration.
}
\description{
Inspect the consistency of a set of clusterings by calculating
their element-wise clustering frustration.
}
\examples{
clustering.list = list()
for (i in 1:20){
  km.res = kmeans(mtcars, 3)$cluster
  clustering.list[[i]] = create_clustering(km.res)
}
element_frustration(clustering.list)
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
