% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clus_opt_thresh_3class.R
\name{plot.clus_opt_thres3}
\alias{plot.clus_opt_thres3}
\title{Plot of confidence regions for covariate-specific optimal pair of thresholds.}
\usage{
\method{plot}{clus_opt_thres3}(
  x,
  ci_level = 0.95,
  colors = NULL,
  xlims,
  ylims,
  size_point = 0.5,
  size_path = 0.5,
  names_labels,
  nrow_legend = 1,
  file_name = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "clus_opt_thres3", i.e., a result of \code{\link{clus_opt_thres3}}.}

\item{ci_level}{confidence level to be used for constructing the confidence regions; default is 0.95.}

\item{colors}{a string vector for the name(s) specifying color(s) to be used for drawing confidence regions. If specified, the dimension of the vector needs to be equal the number of considered points (each point corresponds to a set of values for the covariates).}

\item{xlims, ylims}{numeric vectors of dimension 2, giving the limits for x and y axes in the plot.}

\item{size_point, size_path}{numeric values, indicating sizes for point(s) and line(s) in the plot.}

\item{names_labels}{an optional character vector giving the label name for covariates.}

\item{nrow_legend}{an optional number of rows in the legend.}

\item{file_name}{File name to create on disk.}

\item{...}{further arguments used with \code{\link{ggexport}} function, for example, \code{width}, \code{height}.}
}
\value{
\code{plot.clus_opt_thres3} returns plots of confidence regions of covariate-specific optimal pair of thresholds.
}
\description{
This function plots confidence regions for covariate-specific optimal pair of thresholds.
}
\details{
\code{plot.clus_opt_thres3} provides plots of confidence regions (and point estimates) of covariate-specific optimal pair of thresholds. The plots are based on \code{ggplot()}.
}
\seealso{
\code{\link{clus_opt_thres3}}
}
