% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGraf.R
\name{plotGraf}
\alias{plotGraf}
\title{Plot Graf f(x)}
\usage{
plotGraf(f, x, title, xmin, xmax, dx = 0.1, xlab, ylab, px = 0, py = 0,
  labelx = TRUE, labely = TRUE)
}
\arguments{
\item{f}{function}

\item{x}{numerical values (number or vector)}

\item{title}{an overall title for the plot}

\item{xmin}{number, default value xmin = -1}

\item{xmax}{number, default value xmax = 1}

\item{dx}{positive number, default value dx = 0.1}

\item{xlab}{a title for the x axis: see \link[graphics]{title}.}

\item{ylab}{a title for the y axis: see \link[graphics]{title}.}

\item{px}{numerical values (number or vector) in which are auxiliary line on axis x render default value \eqn{px = 0}}

\item{py}{numerical values (number or vector) in which are auxiliary line on axis y render default value \eqn{py = 0}}

\item{labelx}{rendering auxiliary line default value TRUE}

\item{labely}{rendering auxiliary line default value TRUE}
}
\value{
Graf of function f in argument x or in range [xmin, xmax] with step dx
}
\description{
plotGraf(f, x, xmin, xmax) plots graf of complex function f in real arguments x or in range [xmin, xmax] with step dx
}
\details{
function with optional parameters must be pass as lambda function f = function(x) f(x, optional parameters)
}

