% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_Beta.R
\name{cfX_Beta}
\alias{cfX_Beta}
\title{Characteristic function of Beta distribution}
\usage{
cfX_Beta(t, alpha = 1, beta = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{alpha}{shape, aplha > 0, default value aplha = 1}

\item{beta}{shape, beta > 0, default value beta = 1}
}
\value{
characteristic function cf(t) of the Beta distribution
}
\description{
cfX_Beta(t,alpha, beta) evaluates the characteristic function cf(t) of
the Beta distribution with the parameter alpha (shape, alpha > 0) and beta (shape, beta > 0)
defined on the interval (0,1), i.e. beta distribution with the Mean = alpha / (alpha + beta)
and the Variance = (alpha*beta) / ((alpha+beta)^2*(alpha+beta+1)).
Then, the standard deviation is given by STD = sqrt(Variance)
i.e.
cf(t) = cfX_Beta(t,alpha,beta) = 1F1(alpha ,alpha + beta , i*t)
where 1F1(.;.;.) is the Confluent hypergeometric function.
}
\examples{
## EXAMPLE1 (CF of the Beta distribution with alpha = 1/2, beta = 3/2)
alpha <- 1 / 2
beta <- 3 / 2
t <- seq(-50, 50, length.out = 501)
plotGraf(function(t)
  cfX_Beta(t, alpha, beta), t, title = "CF of the Beta distribution with alpha = 1/2, beta = 3/2")

## EXAMPLE2 (PDF/CDF of the Beta distribution with alpha = 1/2, beta = 3/2)
alpha <- 1 / 2
beta <- 3 / 2
cf <- function(t)
  cfX_Beta(t, alpha, beta)
x <- seq(0, 1, length.out = 101)
xRange <- 1
option <- list()
option$dx <- 2 * pi / xRange
result <- cf2DistGP(cf, x, option = option)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Beta_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}},
  \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}
}

