% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_helpers.R
\name{substitutes}
\alias{substitutes}
\title{Make statement for substitutes}
\usage{
substitutes(X1, X2, Y)
}
\arguments{
\item{X1}{A character. The quoted name of the input node 1.}

\item{X2}{A character. The quoted name of the input node 2.}

\item{Y}{A character. The quoted name of the outcome node.}
}
\value{
A character statement of class \code{statement}
}
\description{
Generate a statement for X1, X1 substitute for each other in the production of Y
}
\examples{
\donttest{
get_query_types(model = make_model('A -> B <- C'),
         query = substitutes('A', 'C', 'B'),map = "causal_type")

query_model(model = make_model('A -> B <- C'),
         queries = substitutes('A', 'C', 'B'),
         using = 'parameters')
}
}
\seealso{
Other statements: 
\code{\link{complements}()},
\code{\link{decreasing}()},
\code{\link{increasing}()},
\code{\link{interacts}()},
\code{\link{non_decreasing}()},
\code{\link{non_increasing}()},
\code{\link{te}()}
}
\concept{statements}
