% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mbsts.R
\name{model}
\alias{model}
\title{Multivariate structural time series model definition}
\usage{
model(y, components, seas.period = NULL, cycle.period = NULL)
}
\arguments{
\item{y}{t x d data.frame (or matrix) of observations, where d is the number of time series
in the multivariate model.}

\item{components}{Character vector specifying the components of the
multivariate structural time series model. Possible values are c("trend",
"slope", "seasonal", "cycle").}

\item{seas.period}{Length of the seasonal pattern, if present.}

\item{cycle.period}{Length of the cycle pattern, if present.}
}
\value{
An object of class 'SSModel'.
}
\description{
Multivariate structural time series model definition
}
\examples{
# Example 1 : local level + seasonal
y <- cbind(seq(0.5,200,by=0.5)*0.1 + rnorm(400),
           seq(100.25,200,by=0.25)*0.05 + rnorm(400),
           rnorm(400, 5,1))
model.1 <- model(y, components = c("trend","seasonal"), seas.period = 7)

# Example 2: local level  + cycle
t <- seq(from = 0,to = 4*pi, length.out=300)
y <- cbind(3*sin(2*t)+rnorm(300), 2*cos(2*t) + rnorm(300))
model.2 <- model(y, components = c("trend", "cycle"), cycle.period = 75)
}
\keyword{internal}
