% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/causal_class.R
\name{cfx}
\alias{cfx}
\title{Creates a CausalFX Problem Instance}
\usage{
cfx(x, y, latent_idx = NULL, dat = NULL, g = NULL, model = NULL,
  num_v_max = 20)
}
\arguments{
\item{x}{the index of the treatment variable.}

\item{y}{the index of the outcome variable.}

\item{latent_idx}{an array with the indices of variables which should be considered latent}

\item{dat}{a matrix of binary data, can be ignored if a model is provided.}

\item{g}{a binary matrix encoding a causal graph, where g[i, j] == 1 if
a directed edge from vertex \eqn{j} to \eqn{i} should exist, 0 otherwise. This is only required
if a ground truth model exists.}

\item{model}{if \code{g} is specified, this needs to be specified too. This argument should be
a list of conditional probability tables, each encoding the conditional probability of
each vertex in \code{g} given its parents. Entry \code{model[[i]]} is
an array of non-negative numbers, describing the probability of random variable/vertex
\eqn{i} being equal to 1. In particular, \code{model[[i]][j]} is the conditional
probability of this event given that the parents of \eqn{i} are in state \eqn{j}.
States are indexed as follows. If \eqn{S} is the binary string corresponding to the
binary values of the parents of \eqn{i} in \code{g}, sorted by their index, then
\eqn{j} is given by \eqn{1 + bin2dec(S)}, where \eqn{bin2dec} is the transformation of
a binary string into a decimal number.}

\item{num_v_max}{the maximum dimensionality in which the joint distribution implied by a model is pre-computed.
                Having this pre-computed can speed up some computations for methods that use the provided
                ground truth model. Because the space required to store a joint distribution
                grows exponentially with the dimensionality, this quantity cannot be too large.}
}
\value{
A \code{cfx} object, which contains the following fields:
 \item{\code{X_idx}}{the index of the treatment variable in the data/graph.}
 \item{\code{Y_idx}}{the index of the outcome variable in the data/graph.}
 \item{\code{latent_idx}}{the array of latent variable indices given as input.}
 \item{\code{data}}{the data given as input.}
 \item{\code{graph}}{the graph given as input.}
 \item{\code{varnames}}{an array of strings with the names of the variables, as given by \code{data}.
                        If \code{data} has no column names or it is not provided, this is given a default value, where
                        variable \eqn{i} is assigned the name "\code{X}".}
 \item{\code{model}}{the model given as input.}
 \item{\code{ancestrals}}{a list of arrays (if \code{g} is provided), where \code{ancestrals[[i]]} is the array of the indices of
                          the ancestrals of \eqn{i} in \code{g}, excluding \eqn{i} itself.}
 \item{\code{probs}}{a multidimensional array (if \code{g} is provided) of the same dimensionality as
                     \code{g}, where each entry corresponds to the probability of that particular assignment of variable values.
                     This is \code{NULL} if the dimensionality of \code{g} is greater than \code{num_v_max}.}
}
\description{
Set up an object describing a causal inference problem of finding the
average causal effect of some treatment on some outcome. Currently, only
binary data is supported. The problem specification also allows the specification
of a synthetic model, for simulation studies.
}

