% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom_ad.R
\name{catr_atom_get_address}
\alias{catr_atom_get_address}
\title{ATOM INSPIRE: Download all the Addresses of a Municipality}
\usage{
catr_atom_get_address(
  munic,
  to = NULL,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{munic}{Municipality to extract, It can be a part of a string or the
cadastral code. See \code{\link[=catr_atom_search_munic]{catr_atom_search_munic()}} for getting the cadastral
codes.}

\item{to}{Optional parameter for defining the Territorial Office to which
\code{munic} belongs. This parameter is a helper for narrowing the search.}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching} section on \code{\link[=catr_set_cache_dir]{catr_set_cache_dir()}}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \CRANpkg{sf} object.
}
\description{
Get the spatial data of all the addresses belonging to a single
municipality using the INSPIRE ATOM service. Additionally, the function also
returns the corresponding street information on the fields with the
prefix \verb{tfname_*}.
}
\examples{
\donttest{
s <- catr_atom_get_address("Melque",
  to = "Segovia"
)

library(ggplot2)

ggplot(s) +
  geom_sf(aes(color = specification)) +
  coord_sf(
    xlim = c(376200, 376850),
    ylim = c(4545000, 4546000)
  ) +
  labs(
    title = "Addresses",
    subtitle = "Melque de Cercos, Segovia"
  )
}

}
\references{
\href{https://www.catastro.minhap.es/webinspire/documentos/inspire-ATOM.pdf}{API Documentation}

\href{https://www.catastro.minhap.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_search_munic}()}

Other addresses: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_wfs_get_address_bbox}()}

Other spatial: 
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{ATOM}
\concept{INSPIRE}
\concept{addresses}
\concept{spatial}
