% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCalCurve.R
\name{genCalCurve}
\alias{genCalCurve}
\title{Calibration performance using the generalized calibration framework}
\usage{
genCalCurve(
  y,
  yHat,
  family,
  plot = TRUE,
  Smooth = FALSE,
  GLMCal = TRUE,
  lwdIdeal = 2,
  colIdeal = "gray",
  ltyIdeal = 1,
  lwdSmooth = 1,
  colSmooth = "blue",
  ltySmooth = 1,
  argzSmooth = alist(degree = 2),
  lwdGLMCal = 1,
  colGLMCal = "red",
  ltyGLMCal = 1,
  AddStats = T,
  Digits = 3,
  cexStats = 1,
  lwdLeg = 1.5,
  Legend = TRUE,
  legendPos = "bottomright",
  xLim = NULL,
  yLim = NULL,
  posStats = NULL,
  confLimitsSmooth = c("none", "bootstrap", "pointwise"),
  confLevel = 0.95,
  Title = "Calibration plot",
  xlab = "Predicted value",
  ylab = "Empirical average",
  EmpiricalDistribution = TRUE,
  length.seg = 1,
  ...
)
}
\arguments{
\item{y}{a vector with the values for the response variable}

\item{yHat}{a vector with the predicted values}

\item{family}{a description of the type of distribution and link function in the model. This can be a character string naming a family function, a family function or the result of a call to a family function.
(See family for details of family functions.)}

\item{plot}{logical, indicating if a plot should be made or not.}

\item{Smooth}{logical, indicating if the flexible calibration curve should be estimated.}

\item{GLMCal}{logical, indicating if the GLM calibration curve has to be estimated.}

\item{lwdIdeal}{the line width of the ideal line.}

\item{colIdeal}{the color of the ideal line.}

\item{ltyIdeal}{the line type of the ideal line.}

\item{lwdSmooth}{the line width of the flexible calibration curve.}

\item{colSmooth}{the color of the flexible calibration curve.}

\item{ltySmooth}{the line type of the flexible calibration curve.}

\item{argzSmooth}{arguments passed to \code{\link{loess}}.}

\item{lwdGLMCal}{the line width of the GLM calibration curve.}

\item{colGLMCal}{the color of the GLM calibration curve.}

\item{ltyGLMCal}{the line type of the GLM calibration curve.}

\item{AddStats}{logical, indicating whether to add the values of the generalized calibration slope and intercept to the plot.}

\item{Digits}{the number of digits of the generalized calibration slope and intercept.}

\item{cexStats}{the font size of the statistics shown on the plot.}

\item{lwdLeg}{the line width in the legend.}

\item{Legend}{logical, indicating whether the legend has to be added.}

\item{legendPos}{the position of the legend on the plot.}

\item{xLim, yLim}{numeric vectors of length 2, giving the x and y coordinates ranges (see \code{\link{plot.window}})}

\item{posStats}{numeric vector of length 2, specifying the x and y coordinates of the statistics (generalized calibration curve and intercept) printed on the plot. Default is \code{NULL}
which places the statistics in the top left corner of the plot.}

\item{confLimitsSmooth}{character vector to indicate if and how the confidence limits for the flexible calibration curve have to be computed. \code{"none"} omits the confidence limits,
\code{"bootstrap"} uses 2000 bootstrap samples to calculate the 95\% confidence limits and \code{"pointwise"} uses the pointwise confidence limits.}

\item{confLevel}{the confidence level for the calculation of the pointwise confidence limits of the flexible calibration curve.}

\item{Title}{the title of the plot}

\item{xlab}{x-axis label, default is \code{"Predicted value"}.}

\item{ylab}{y-axis label, default is \code{"Empirical average"}.}

\item{EmpiricalDistribution}{logical, indicating if the empirical distribution of the predicted values has to be added to the bottom of the plot.}

\item{length.seg}{controls the length of the histogram lines. Default is \code{1}.}

\item{...}{arguments to be passed to \code{\link{plot}}, see \code{\link{par}}}
}
\value{
An object of type \code{GeneralizedCalibrationCurve} with the following slots:

\item{call}{the matched call.}

\item{ggPlot}{the ggplot object.}

\item{stats}{a vector containing performance measures of calibration.}

\item{cl.level}{the confidence level used.}

\item{Calibration}{contains the calibration intercept and slope, together with their confidence intervals.}

\item{Cindex}{the value of the c-statistic, together with its confidence interval.}

\item{warningMessages}{if any, the warning messages that were printed while running the function.}

\item{CalibrationCurves}{The coordinates for plotting the calibration curves. }
}
\description{
Function to assess the calibration performance of a prediction model where the outcome's distribution is a member of the exponential family (De Cock Campo, 2023).
The function plots the generalized calibration curve and computes the generalized calibration slope and intercept.
}
\examples{
library(CalibrationCurves)
library(mgcv)
data("poissontraindata")
data("poissontestdata")

glmFit = glm(Y ~ ., data = poissontraindata, family = poisson)

# Example of a well calibrated poisson prediction model
yOOS = poissontestdata$Y
yHat = predict(glmFit, newdata = poissontestdata, type = "response")
genCalCurve(yOOS, yHat, family = "poisson", plot = TRUE)

# Example of an overfit poisson prediction model
gamFit = gam(Y ~ x1 + x3 + x1:x3 + s(x5), data = poissontraindata, family = poisson)
yHat = as.vector(predict(gamFit, newdata = poissontestdata, type = "response"))
genCalCurve(yOOS, yHat, family = "poisson", plot = TRUE)

# Example of an underfit poisson prediction model
glmFit = glm(Y ~ x2, data = poissontraindata, family = poisson)
yOOS = poissontestdata$Y
yHat = predict(glmFit, newdata = poissontestdata, type = "response")
genCalCurve(yOOS, yHat, family = "poisson", plot = TRUE)
}
\references{
De Cock Campo, B. (2023). Towards reliable predictive analytics: a generalized calibration framework. arXiv:2309.08559, available at \url{https://arxiv.org/abs/2309.08559}.
}
