% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{MatrixFrac-class}
\alias{MatrixFrac-class}
\alias{.MatrixFrac}
\alias{MatrixFrac}
\alias{allow_complex,MatrixFrac-method}
\alias{to_numeric,MatrixFrac-method}
\alias{validate_args,MatrixFrac-method}
\alias{dim_from_args,MatrixFrac-method}
\alias{sign_from_args,MatrixFrac-method}
\alias{is_atom_convex,MatrixFrac-method}
\alias{is_atom_concave,MatrixFrac-method}
\alias{is_incr,MatrixFrac-method}
\alias{is_decr,MatrixFrac-method}
\alias{is_quadratic,MatrixFrac-method}
\alias{is_qpwa,MatrixFrac-method}
\alias{.domain,MatrixFrac-method}
\alias{.grad,MatrixFrac-method}
\title{The MatrixFrac class.}
\usage{
MatrixFrac(X, P)

\S4method{allow_complex}{MatrixFrac}(object)

\S4method{to_numeric}{MatrixFrac}(object, values)

\S4method{validate_args}{MatrixFrac}(object)

\S4method{dim_from_args}{MatrixFrac}(object)

\S4method{sign_from_args}{MatrixFrac}(object)

\S4method{is_atom_convex}{MatrixFrac}(object)

\S4method{is_atom_concave}{MatrixFrac}(object)

\S4method{is_incr}{MatrixFrac}(object, idx)

\S4method{is_decr}{MatrixFrac}(object, idx)

\S4method{is_quadratic}{MatrixFrac}(object)

\S4method{is_qpwa}{MatrixFrac}(object)

\S4method{.domain}{MatrixFrac}(object)

\S4method{.grad}{MatrixFrac}(object, values)
}
\arguments{
\item{X}{An \linkS4class{Expression} or numeric matrix.}

\item{P}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{MatrixFrac} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
The matrix fraction function \eqn{tr(X^T P^{-1} X)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{allow_complex}: Does the atom handle complex numbers?

\item \code{to_numeric}: The trace of \eqn{X^TP^{-1}X}.

\item \code{validate_args}: Check that the dimensions of \code{x} and \code{P} match.

\item \code{dim_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is not monotonic in any argument.

\item \code{is_decr}: The atom is not monotonic in any argument.

\item \code{is_quadratic}: True if x is affine and P is constant.

\item \code{is_qpwa}: True if x is piecewise linear and P is constant.

\item \code{.domain}: Returns constraints describing the domain of the node

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable
}}

\section{Slots}{

\describe{
\item{\code{X}}{An \linkS4class{Expression} or numeric matrix.}

\item{\code{P}}{An \linkS4class{Expression} or numeric matrix.}
}}

