% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{tv}
\alias{tv}
\alias{total_variation}
\title{Total Variation}
\usage{
tv(value, ...)
}
\arguments{
\item{value}{An \linkS4class{Expression}, vector, or matrix.}

\item{...}{(Optional) \linkS4class{Expression} objects or numeric constants that extend the third dimension of value.}
}
\value{
An \linkS4class{Expression} representing the total variation of the input.
}
\description{
The total variation of a vector, matrix, or list of matrices. Uses L1 norm of discrete gradients for vectors and L2 norm of discrete gradients for matrices.
}
\examples{
rows <- 10
cols <- 10
Uorig <- matrix(sample(0:255, size = rows * cols, replace = TRUE), nrow = rows, ncol = cols)

# Known is 1 if the pixel is known, 0 if the pixel was corrupted
Known <- matrix(0, nrow = rows, ncol = cols)
for(i in 1:rows) {
   for(j in 1:cols) {
      if(stats::runif(1) > 0.7)
         Known[i,j] <- 1
   }
}
Ucorr <- Known \%*\% Uorig

# Recover the original image using total variation in-painting
U <- Variable(rows, cols)
obj <- Minimize(tv(U))
constraints <- list(Known * U == Known * Ucorr)
prob <- Problem(obj, constraints)
result <- solve(prob, solver = "SCS")
result$getValue(U)
}
