% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{UpperTri-class}
\alias{UpperTri-class}
\alias{.UpperTri}
\alias{UpperTri}
\alias{to_numeric,UpperTri-method}
\alias{validate_args,UpperTri-method}
\alias{dim_from_args,UpperTri-method}
\alias{is_atom_log_log_convex,UpperTri-method}
\alias{is_atom_log_log_concave,UpperTri-method}
\alias{graph_implementation,UpperTri-method}
\title{The UpperTri class.}
\usage{
UpperTri(expr)

\S4method{to_numeric}{UpperTri}(object, values)

\S4method{validate_args}{UpperTri}(object)

\S4method{dim_from_args}{UpperTri}(object)

\S4method{is_atom_log_log_convex}{UpperTri}(object)

\S4method{is_atom_log_log_concave}{UpperTri}(object)

\S4method{graph_implementation}{UpperTri}(object, arg_objs, dim, data = NA_real_)
}
\arguments{
\item{expr}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{An \linkS4class{UpperTri} object.}

\item{values}{A list of arguments to the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{dim}{A vector representing the dimensions of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
The vectorized strictly upper triagonal entries of a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(UpperTri)}: Vectorize the upper triagonal entries.

\item \code{validate_args(UpperTri)}: Check the argument is a square matrix.

\item \code{dim_from_args(UpperTri)}: The dimensions of the atom.

\item \code{is_atom_log_log_convex(UpperTri)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(UpperTri)}: Is the atom log-log concave?

\item \code{graph_implementation(UpperTri)}: The graph implementation of the atom.

}}
\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} or numeric matrix.}
}}

