% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{is_dcp}
\alias{is_dcp}
\title{DCP Compliance}
\usage{
is_dcp(object)
}
\arguments{
\item{object}{A \linkS4class{Problem} or \linkS4class{Expression} object.}
}
\value{
A logical value indicating whether the problem or expression is DCP compliant, i.e. no unknown curvatures.
}
\description{
Determine if a problem or expression complies with the disciplined convex programming rules.
}
\examples{
x <- Variable()
prob <- Problem(Minimize(x^2), list(x >= 5))
is_dcp(prob)
solve(prob)
}
