% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/atoms.R
\name{curvature-comp}
\alias{curvature-comp}
\alias{is_incr}
\alias{is_decr}
\alias{is_incr,Atom-method}
\alias{is_decr,Atom-method}
\title{Curvature of Composition}
\usage{
is_incr(object, idx)

is_decr(object, idx)

\S4method{is_incr}{Atom}(object, idx)

\S4method{is_decr}{Atom}(object, idx)
}
\arguments{
\item{object}{A \linkS4class{Atom} object.}

\item{idx}{An index into the atom.}
}
\value{
A logical value.
}
\description{
Determine whether a composition is non-decreasing or non-increasing in an index.
}
\examples{
x <- Variable()
is_incr(log(x), 1)
is_incr(x^2, 1)
is_decr(min(x), 1)
is_decr(abs(x), 1)
}
