% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{pf_eigenvalue}
\alias{pf_eigenvalue}
\title{Perron-Frobenius Eigenvalue}
\usage{
pf_eigenvalue(X)
}
\arguments{
\item{X}{An \linkS4class{Expression} or positive square matrix.}
}
\value{
An \linkS4class{Expression} representing the largest eigenvalue of the input.
}
\description{
The Perron-Frobenius eigenvalue of a positive matrix.
}
\details{
For an elementwise positive matrix \eqn{X}, this atom represents its spectral radius, i.e., the magnitude of its largest eigenvalue.
Because \eqn{X} is positive, the spectral radius equals its largest eigenvalue, which is guaranteed to be positive.

This atom is log-log convex.
}
\examples{
n <- 3
X <- Variable(n, n, pos=TRUE)
objective_fn <- pf_eigenvalue(X)
constraints <- list( X[1,1]== 1.0,
                     X[1,3] == 1.9,
                     X[2,2] == .8,
                     X[3,1] == 3.2,
                     X[3,2] == 5.9,
                     X[1, 2] * X[2, 1] * X[2,3] * X[3,3] == 1)
problem <- Problem(Minimize(objective_fn), constraints)
result <- solve(problem, gp=TRUE)
result$value
result$getValue(X)

}
