% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{cvxr_norm}
\alias{cvxr_norm}
\title{Matrix Norm (Alternative)}
\usage{
cvxr_norm(x, p = 2, axis = NA_real_, keepdims = FALSE)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant representing a vector or matrix.}

\item{p}{The type of norm. May be a number (p-norm), "inf" (infinity-norm), "nuc" (nuclear norm), or "fro" (Frobenius norm). The default is \code{p = 2}.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}
}
\value{
An \linkS4class{Expression} representing the norm.
}
\description{
A wrapper on the different norm atoms. This is different from the standard "norm" method in the R base package.
If \code{p = 2}, \code{axis = NA}, and \code{x} is a matrix, this returns the maximium singular value.
}
\seealso{
\link[CVXR]{norm}
}
