% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcp2cone.R
\docType{class}
\name{ConeMatrixStuffing-class}
\alias{ConeMatrixStuffing-class}
\alias{ConeMatrixStuffing}
\alias{accepts,ConeMatrixStuffing,Problem-method}
\alias{stuffed_objective,ConeMatrixStuffing,Problem,CoeffExtractor-method}
\title{Construct Matrices for Linear Cone Problems}
\usage{
\S4method{accepts}{ConeMatrixStuffing,Problem}(object, problem)

\S4method{stuffed_objective}{ConeMatrixStuffing,Problem,CoeffExtractor}(object, problem, extractor)
}
\arguments{
\item{object}{A \linkS4class{ConeMatrixStuffing} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{extractor}{Used to extract the affine coefficients of the objective.}
}
\description{
Linear cone problems are assumed to have a linear objective and cone constraints,
which may have zero or more arguments, all of which must be affine.
}
\details{
minimize c^Tx
subject to cone_constr1(A_1*x + b_1, ...)
           ...
           cone_constrK(A_K*x + b_K, ...)
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts}: Is the solver accepted?

\item \code{stuffed_objective}: Returns a list of the stuffed matrices
}}

