% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{MatrixFrac-class}
\alias{MatrixFrac-class}
\alias{.MatrixFrac}
\alias{MatrixFrac}
\alias{validate_args,MatrixFrac-method}
\alias{to_numeric,MatrixFrac-method}
\alias{size_from_args,MatrixFrac-method}
\alias{sign_from_args,MatrixFrac-method}
\alias{is_atom_convex,MatrixFrac-method}
\alias{is_atom_concave,MatrixFrac-method}
\alias{is_incr,MatrixFrac-method}
\alias{is_decr,MatrixFrac-method}
\alias{is_quadratic,MatrixFrac-method}
\alias{graph_implementation,MatrixFrac-method}
\title{The MatrixFrac class.}
\usage{
MatrixFrac(X, P)

\S4method{validate_args}{MatrixFrac}(object)

\S4method{to_numeric}{MatrixFrac}(object, values)

\S4method{size_from_args}{MatrixFrac}(object)

\S4method{sign_from_args}{MatrixFrac}(object)

\S4method{is_atom_convex}{MatrixFrac}(object)

\S4method{is_atom_concave}{MatrixFrac}(object)

\S4method{is_incr}{MatrixFrac}(object, idx)

\S4method{is_decr}{MatrixFrac}(object, idx)

\S4method{is_quadratic}{MatrixFrac}(object)

\S4method{graph_implementation}{MatrixFrac}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{X}{An \linkS4class{Expression} or numeric matrix.}

\item{P}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{MatrixFrac} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
The matrix fraction function \eqn{tr(X^T P^{-1} X)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check that the dimensions of \code{x} and \code{P} match.

\item \code{to_numeric}: The trace of \eqn{X^TP^{-1}X}.

\item \code{size_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is not monotonic in any argument.

\item \code{is_decr}: The atom is not monotonic in any argument.

\item \code{is_quadratic}: True if x is affine and P is constant.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{X}}{An \linkS4class{Expression} or numeric matrix.}

\item{\code{P}}{An \linkS4class{Expression} or numeric matrix.}
}}

