% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/affine.R
\docType{methods}
\name{[,Expression,missing,missing,ANY-method}
\alias{[,Expression,missing,missing,ANY-method}
\alias{[,Expression,index,missing,ANY-method}
\alias{[,Expression,missing,index,ANY-method}
\alias{[,Expression,index,index,ANY-method}
\alias{[,Expression,matrix,index,ANY-method}
\alias{[,Expression,index,matrix,ANY-method}
\alias{[,Expression,matrix,matrix,ANY-method}
\alias{[,Expression,matrix,missing,ANY-method}
\alias{Index-class}
\alias{.Index}
\alias{Index}
\alias{to_numeric,Index-method}
\alias{size_from_args,Index-method}
\alias{get_data,Index-method}
\alias{graph_implementation,Index-method}
\title{The Index class.}
\usage{
\S4method{[}{Expression,missing,missing,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,index,missing,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,missing,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,index,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,index,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,index,matrix,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,matrix,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Expression,matrix,missing,ANY}(x, i, j, ..., drop = TRUE)

Index(expr, key)

\S4method{to_numeric}{Index}(object, values)

\S4method{size_from_args}{Index}(object)

\S4method{get_data}{Index}(object)

\S4method{graph_implementation}{Index}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x, object}{An \linkS4class{Index} object.}

\item{i, j}{The row and column indices of the slice.}

\item{...}{(Unimplemented) Optional arguments.}

\item{drop}{(Unimplemented) A logical value indicating whether the result should be coerced to the lowest possible dimension.}

\item{expr}{An \linkS4class{Expression} representing a vector or matrix.}

\item{key}{A list containing the start index, end index, and step size of the slice.}

\item{values}{A list of arguments to the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents indexing or slicing into a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The index/slice into the given value.

\item \code{size_from_args}: The size of the atom.

\item \code{get_data}: A list containing \code{key}.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{key}}{A list containing the start index, end index, and step size of the slice.}
}}

