% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{log_det}
\alias{log_det}
\title{Log-Determinant}
\usage{
log_det(A)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}
}
\value{
An \linkS4class{Expression} representing the log-determinant of the input.
}
\description{
The natural logarithm of the determinant of a matrix, \eqn{\log\det(A)}.
}
\examples{
x <- t(data.frame(c(0.55, 0.25, -0.2, -0.25, -0.0, 0.4),
                  c(0.0, 0.35, 0.2, -0.1, -0.3, -0.2)))
n <- nrow(x)
m <- ncol(x)

A <- Variable(n,n)
b <- Variable(n)
obj <- Maximize(log_det(A))
constr <- lapply(1:m, function(i) { p_norm(A \%*\% as.matrix(x[,i]) + b) <= 1 })
prob <- Problem(obj, constr)
result <- solve(prob)
result$value
}
