% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{harmonic_mean}
\alias{harmonic_mean}
\title{Harmonic Mean}
\usage{
harmonic_mean(x)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}
}
\value{
An \linkS4class{Expression} representing the harmonic mean of the input.
}
\description{
The harmonic mean, \eqn{\left(\frac{1}{n} \sum_{i=1}^n x_i^{-1}\right)^{-1}}. For a matrix, the function is applied over all entries.
}
\examples{
x <- Variable()
prob <- Problem(Maximize(harmonic_mean(x)), list(x >= 0, x <= 5))
result <- solve(prob)
result$value
result$getValue(x)
}
