% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Logistic-class}
\alias{Logistic-class}
\alias{.Logistic}
\alias{Logistic}
\alias{to_numeric,Logistic-method}
\alias{sign_from_args,Logistic-method}
\alias{is_atom_convex,Logistic-method}
\alias{is_atom_concave,Logistic-method}
\alias{is_incr,Logistic-method}
\alias{is_decr,Logistic-method}
\alias{graph_implementation,Logistic-method}
\title{The Logistic class.}
\usage{
Logistic(x)

\S4method{to_numeric}{Logistic}(object, values)

\S4method{sign_from_args}{Logistic}(object)

\S4method{is_atom_convex}{Logistic}(object)

\S4method{is_atom_concave}{Logistic}(object)

\S4method{is_incr}{Logistic}(object, idx)

\S4method{is_decr}{Logistic}(object, idx)

\S4method{graph_implementation}{Logistic}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant.}

\item{object}{A \linkS4class{Logistic} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise operation \eqn{\log(1 + e^x)}.
This is a special case of log(sum(exp)) that evaluates to a vector rather than to a scalar,
which is useful for logistic regression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: Evaluates \code{e^x} elementwise, adds one, and takes the natural logarithm.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is weakly increasing.

\item \code{is_decr}: The atom is not weakly decreasing.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}
}}

