% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{Int-class}
\alias{Int-class}
\alias{.Int}
\alias{Int}
\alias{as.character,Int-method}
\alias{canonicalize,Int-method}
\title{The Int class.}
\usage{
Int(rows = 1, cols = 1, name = NA_character_)

\S4method{as.character}{Int}(x)

\S4method{canonicalize}{Int}(object)
}
\arguments{
\item{rows}{The number of rows in the variable.}

\item{cols}{The number of columns in the variable.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{x, object}{An \linkS4class{Int} object.}
}
\description{
This class represents an integer variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{canonicalize}: Enforce that the variable be an integer.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique identification number used internally.}

\item{\code{rows}}{The number of rows in the variable.}

\item{\code{cols}}{The number of columns in the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}

\item{\code{primal_value}}{(Internal) The primal value of the variable stored internally.}
}}

\examples{
x <- Int(3, name = "i") ## 3-int variable
y <- Int(3, 3, name = "j") # Matrix variable
as.character(y)
id(y)
is_positive(x)
is_negative(x)
size(y)
name(y)
value(y) <- matrix(1:9, nrow = 3)
value(y)
grad(y)
variables(y)
canonicalize(y)
}
