#' @title Auxiliary function for the log-likelihood estimation of CUB models
#' @description Compute the opposite of the scalar function that is maximized when running
#'  the E-M algorithm for CUB models with covariates for the uncertainty parameter. 
#' @aliases effe10
#' @usage effe10(bet, esterno10)
#' @param bet Vector of the starting values for the parameters to be estimated 
#' @param esterno10 A matrix binding together the matrix of the selected covariates  
#' (accounting for an intercept term) and a vector (whose length equals the number of observations) 
#' of the posterior probabilities that each observation has been generated by the first component 
#' distribution of the mixture
#' @keywords internal 
#' @details It is called as an argument for optim within CUB function for models with covariates for
#' uncertainty or for both feeling and uncertainty


effe10 <-
function(bet,esterno10){
  tauno<-esterno10[,1]
  covar<-esterno10[,2:ncol(esterno10)]
  return(sum(log(1+exp(-covar%*%bet))+(1-tauno)*(covar%*%bet)))
}
